<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item"><a
                                        href="<?php echo e(route('admin.banners.index')); ?>">Banners</a></li>
                                <li class="breadcrumb-item active">Edit Banner</li>
                            </ol>
                        </div>
                    <?php $__env->startSection('page_title'); ?>
                        Edit Banner
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Edit Banner</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="<?php echo e(route('admin.banners.update', $banner)); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="form-group">
                                <label for="image">Current Image</label>
                                <div>
                                    <img src="<?php echo e(asset('uploads/banners/' . $banner->image)); ?>"
                                        alt="<?php echo e($banner->title); ?>" height="100">
                                </div>
                                <br>
                                <label for="image">Change Banner Image</label>
                                <input type="file" name="image" id="image" class="form-control">
                                <small class="form-text text-muted">Leave blank to keep the current image. Recommended
                                    size: 1200x400px</small>
                            </div>

                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" id="title" class="form-control"
                                    value="<?php echo e(old('title', $banner->title)); ?>">
                            </div>

                            <div class="form-group">
                                <label for="priority">Priority *</label>
                                <input type="number" name="priority" id="priority" class="form-control"
                                    value="<?php echo e(old('priority', $banner->priority)); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="status">Status *</label>
                                <select name="status" id="status" class="form-control" required>
                                    <option value="1" <?php echo e(old('status', $banner->status) == 1 ? 'selected' : ''); ?>>
                                        Active</option>
                                    <option value="0" <?php echo e(old('status', $banner->status) == 0 ? 'selected' : ''); ?>>
                                        Inactive</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Update Banner</button>
                            <a href="<?php echo e(route('admin.banners.index')); ?>" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/banners/edit.blade.php ENDPATH**/ ?>