<!DOCTYPE html>
<?php
    $settings = \App\Models\Setting::first();
?>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <title><?php echo e($settings->site_name); ?></title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta content="A fully featured admin theme which can be used to build CRM, CMS, etc." name="description" />
        <meta content="Coderthemes" name="author" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <!-- App favicon -->
        <link rel="shortcut icon" href="<?php echo e(asset('favicon.png')); ?>">
        <!-- Bootstrap select pluings -->
        <link href="<?php echo e(asset('adminT/assets/libs/bootstrap-select/bootstrap-select.min.css')); ?>" rel="stylesheet" type="text/css" />
        <!-- App css -->
        <link href="<?php echo e(asset('adminT/assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" id="bootstrap-stylesheet" />
        <link href="<?php echo e(asset('adminT/assets/css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset('adminT/assets/css/app.min.css')); ?>" rel="stylesheet" type="text/css"  id="app-stylesheet" />
        <style>
            .authentication-bg {
                background: url("<?php echo e(asset('login_bg.png')); ?>") no-repeat center;
                background-size: cover;
                overflow: hidden;
            }
            /*.login_card {*/
            /*    border: 2px solid #3b3e47;*/
            /*    padding: 0px;*/
            /*    background: #fff;*/
            /*}*/
            /*.authentication-logo {*/
            /*    background: #3b3e47;*/
            /*    padding: 10px 0px 8px;*/
            /*}*/
            /*form {*/
            /*    padding: 10px;*/
            /*}*/
            /*button {*/
            /*    background: #3b3e47 !important;*/
            /*    border-color: #3b3e47 !important;*/
            /*}*/
            .form {
                display: flex;
                flex-direction: column;
                gap: 10px;
                background-color: white;
                padding: 2.5em;
                border-radius: 25px;
                transition: .4s ease-in-out;
                box-shadow: rgba(0, 0, 0, 0.4) 1px 2px 2px;
            }

            .form:hover {
                transform: translateX(-0.5em) translateY(-0.5em);
                border: 1px solid #171717;
                box-shadow: 10px 10px 0px #666666;
            }

            .input {
                border-radius: 5px;
                border: 1px solid whitesmoke;
                background-color: whitesmoke;
                outline: none;
                padding: 0.7em;
                transition: .4s ease-in-out;
                width: 100%;
            }

            .input:hover {
                box-shadow: 6px 6px 0px #969696,
                -3px -3px 10px #ffffff;
            }

            .input,
            .input:focus {
                background: #ffffff;
                box-shadow: inset 2px 5px 10px rgba(0,0,0,0.3);
            }

            .form .btn {
                margin-top: 2em;
                align-self: center;
                padding: 0.7em;
                padding-left: 1em;
                padding-right: 1em;
                border-radius: 10px;
                border: none;
                color: #fff;
                transition: .4s ease-in-out;
                box-shadow: rgba(0, 0, 0, 0.4) 1px 1px 1px;
            }

            .form .btn:hover {
                box-shadow: 6px 6px 0px #969696,
                -3px -3px 10px #ffffff;
                transform: translateX(-0.5em) translateY(-0.5em);
            }

            .form .btn:active {
                transition: .2s;
                transform: translateX(0em) translateY(0em);
                box-shadow: none;
            }
        </style>
    </head>
    <body class="authentication-bg">
        <div class="account-pages my-5">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-5 login_card">

                        <?php echo $__env->yieldContent('content'); ?>

                    </div> <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- end container -->
        </div>
        <!-- end page -->
        <!-- Vendor js -->
        <script src="<?php echo e(asset('adminT/assets/js/vendor.min.js')); ?>"></script>
        <!-- Bootstrap select plugin -->
        <script src="<?php echo e(asset('adminT/assets/libs/bootstrap-select/bootstrap-select.min.js')); ?>"></script>
        <!-- App js -->
        <script src="<?php echo e(asset('adminT/assets/js/app.min.js')); ?>"></script>
        <?php echo $__env->yieldContent('jscode'); ?>
    </body>
</html>
<?php /**PATH C:\xampp\htdocs\med_exam_guru\resources\views/layouts/login.blade.php ENDPATH**/ ?>