<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.chapters.index')); ?>">Chapters</a></li>
                                <li class="breadcrumb-item active">Create Chapter</li>
                            </ol>
                        </div>
                    <?php $__env->startSection('page_title'); ?>
                        Create Chapter
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Create New Chapter</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="<?php echo e(route('admin.chapters.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" id="title" class="form-control">
                                    
                            </div>

                            <div class="form-group">
                                <label for="course_id">Course</label>
                                <select name="course_id" id="course_id" class="form-control" required>
                                    <option value="">-- Select Course --</option>
                                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($course->id); ?>" <?php echo e(old('course_id') == $course->id ? 'selected' : ''); ?>>
                                            <?php echo e($course->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>


                            <div class="form-group">
                                <label for="chapter_type">Chapter Type</label>
                                <select name="chapter_type" id="chapter_type" class="form-control" required>
                                    <option value="">-- Select Chapter Type --</option>
                                    <?php $__currentLoopData = chapterTypeOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>">
                                            <?php echo e($label); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group" id="question_div">
                                <label>Question </label>
                                <textarea name="question" class="form-control" rows="4"></textarea>
                            </div>

                            <div class="form-group" id="answer_div">
                                <label>Answer </label>
                                <textarea name="answer" class="form-control" rows="4"></textarea>
                            </div>
                            
                            <div class="form-group" id="explanation_div">
                                <label>Explanation</label>
                                <textarea name="explanation" class="form-control" rows="4"></textarea>
                            </div>


  
                            <!-- <div class="form-group">
                                <label for="is_free">Free/Paid</label>
                                <select name="is_free" id="is_free" class="form-control" required>
                                    <option value="1">Paid</option> 
                                    <option value="0">Free</option>
                                </select>
                            </div> -->

                            <div class="form-group">
                                <label for="order_index" id="order_index_label">Chapter No.</label>
                                <input type="text" name="order_index" id="order_index" class="form-control">
                            </div>

                            <button type="submit" class="btn btn-primary">Create Chapter</button>
                            <a href="<?php echo e(route('admin.chapters.index')); ?>" class="btn btn-secondary">Cancel</a>
                        
                            <script>
                                document.addEventListener("DOMContentLoaded", function () {
                                    const chapterTypeSelect = document.getElementById('chapter_type');
                                    const questionDiv = document.getElementById('question_div');
                                    const answerDiv = document.getElementById('answer_div');
                                    const explanationDiv = document.getElementById('explanation_div');
                                    const orderIndexLabel = document.getElementById('order_index_label');

                                    function toggleQAFields() {
                                        const selectedType = chapterTypeSelect.value;
                                        const shouldShow = selectedType === 'reasoning_question';

                                        questionDiv.style.display = shouldShow ? 'block' : 'none';
                                        answerDiv.style.display = shouldShow ? 'block' : 'none';
                                        explanationDiv.style.display = shouldShow ? 'block' : 'none';
                                        
                                        orderIndexLabel.innerHTML = shouldShow ? 'Question No.' : 'Chapter No.';
                                    }

                                    chapterTypeSelect.addEventListener('change', toggleQAFields);

                                    // Initialize visibility
                                    toggleQAFields();
                                });
                            </script>

                        
                        </form>
                    </div>
                </div> <!-- end card -->
            </div> <!-- end col -->
        </div>
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/chapters/create.blade.php ENDPATH**/ ?>