<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active">College</li>
                            </ol>
                        </div>
                    <?php $__env->startSection('page_title'); ?>
                        Colleges
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <?php if(Session::has('message')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> <?php echo e(Session::get('message')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Colleges</h4>
                            </div>
                            <div class="col-md-6">
                                <a href="<?php echo e(route('admin.colleges.create')); ?>">
                                    <button class="btn btn-success float-right ml-2"><i class="fas fa-plus"></i>
                                        Create College
                                    </button>
                                </a>
                            </div>
                        </div>
                        <hr>
                        <div class="table-responsive">
                            <table id="example" class="table table-striped table-bordered dt-responsive nowrap"
                                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                <thead>
                                    <tr>
                                        <th>Sr. No.</th>
                                        <th>Name</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i=0; ?> 
                                    <?php $__currentLoopData = $college; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $college_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $i++; ?> 
                                        <tr>
                                            <td><?php echo e($i); ?></td>
                                            <td><?php echo e($college_data->name); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('admin.colleges.edit', [$college_data->id])); ?>"
                                                    class="btn btn-primary waves-effect waves-light btn-xs"><i
                                                        class="fas fa-pen"></i></a>
                                                <button data-value="<?php echo e($college_data->id); ?>"
                                                    class="btn btn-danger waves-effect waves-light btn-xs cdelete">
                                                    <i class="fas fa-trash"></i></button>
                                                <form id="deleteform<?php echo e($college_data->id); ?>" method="post"
                                                    action="<?php echo e(route('admin.colleges.destroy', [$college_data->id])); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo e(method_field('DELETE')); ?>

                                                </form>

                                                <a href="<?php echo e(route('admin.college_contents.index', [$college_data->id])); ?>"
                                                        class="btn btn-outline-info btn-xs mt-1"><i
                                                        class="fas fa-file-alt"></i></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('jscode'); ?>
<script>
    $('.cdelete').on('click', function() {
        var id = $(this).data('value');
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonColor: "#348cd4",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it!"
        }).then(function(t) {
            if (t.value == true) {
                $("#deleteform" + id).submit();
            }
        })
    });
</script>
<script language="javascript">
     $('#example').DataTable({
        responsive: true,
        columnDefs: [
            { responsivePriority: 1, targets: 0 }, // keep S.No visible
            { responsivePriority: 2, targets: -1 }, // keep Action visible
            { orderable: false, targets: -1 } // prevent sorting on Action column
        ]
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/colleges/index.blade.php ENDPATH**/ ?>