<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active">Chapters</li>
                            </ol>
                        </div>
                    <?php $__env->startSection('page_title'); ?>
                        Chapters
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <?php if(Session::has('message')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> <?php echo e(Session::get('message')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Chapters</h4>
                            </div>
                            <div class="col-md-6">
                                <a href="<?php echo e(route('admin.chapters.create')); ?>">
                                    <button class="btn btn-success float-right ml-2"><i class="fas fa-plus"></i>
                                        Create Chapter
                                    </button>
                                </a>
                            </div>
                        </div>
                        <hr>
                        <div class="table-responsive">
                            <table id="example" class="table table-striped table-bordered dt-responsive nowrap"
                                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                <thead>
                                    <tr>
                                        <th>Sr. No.</th>
                                        <th>Title</th>
                                        <th>Course</th>
                                        <th>Type</th>
                                        <!-- <th>Free/Paid</th> -->
                                        <th>Chapter No.</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i=0; ?> 
                                    <?php $__currentLoopData = $chapter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $i++; ?> 
                                        <tr>
                                            <td><?php echo e($i); ?></td>
                                            <td><?php echo e($chapter_data->title); ?></td>
                                            <td><?php echo e($chapter_data->course->name); ?></td>
                                            <td><?php echo e($chapter_data->chapter_type_label); ?></td>
                                            <!-- <td>
                                                <?php if($chapter_data->is_free==1): ?>
                                                <span class="badge badge-success">Paid</span>
                                                <?php else: ?>
                                                <span class="badge badge-danger">Free</span>
                                                <?php endif; ?>
                                            </td> -->
                                            <td><?php echo e($chapter_data->chapter_type_label == 'Reasoning Questions' ? 'Question' : 'Chapter'); ?> <?php echo e($chapter_data->order_index); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('admin.chapters.edit', [$chapter_data->id])); ?>"
                                                    class="btn btn-primary waves-effect waves-light btn-xs"><i
                                                        class="fas fa-pen"></i></a>
                                                <button data-value="<?php echo e($chapter_data->id); ?>"
                                                    class="btn btn-danger waves-effect waves-light btn-xs cdelete">
                                                    <i class="fas fa-trash"></i></button>
                                                <form id="deleteform<?php echo e($chapter_data->id); ?>" method="post"
                                                    action="<?php echo e(route('admin.chapters.destroy', [$chapter_data->id])); ?>">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo e(method_field('DELETE')); ?>

                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('jscode'); ?>
<script>
    $('.cdelete').on('click', function() {
        var id = $(this).data('value');
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonColor: "#348cd4",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it!"
        }).then(function(t) {
            if (t.value == true) {
                $("#deleteform" + id).submit();
            }
        })
    });
</script>
<script language="javascript">
    $('#example').DataTable({
        responsive: true
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\med_exam_guru\resources\views/admin/chapters/index.blade.php ENDPATH**/ ?>