<!DOCTYPE html>
<html lang="en">

<head>
    <?php
        $settings = \App\Models\Setting::first();
    ?>
    <meta charset="UTF-8">
    <title>Login</title>
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset($settings->favicon)); ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <style>
        body,
        html {
            height: 100%;
            margin: 0;
        }

        .login-container {
            display: flex;
            height: 100vh;
        }

        .login-left {
            flex: 1;
            background: url('<?php echo e(asset('login_bg.png')); ?>') no-repeat center center;
            background-size: cover;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            color: #fff;
            background-color: #10194E;
            /* fallback color */
        }

        .login-left h2 {
            font-size: 2.5rem;
            font-weight: bold;
            margin-bottom: 1rem;
            text-align: center;
        }

        .login-right {
            flex: 1;
            background: #00001a;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        .login-box {
            width: 100%;
            max-width: 400px;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.08);
            padding: 2.5rem 2rem;
        }

        .login-logo {
            display: block;
            margin: 0 auto 1.5rem auto;
            max-width: 220px;
        }

        .login-title {
            font-size: 2rem;
            font-weight: bold;
            color: #ffffff;
            margin-bottom: 0.5rem;
            text-align: left;
        }

        .login-subtitle {
            color: #ffffff;
            margin-bottom: 2rem;
            font-size: 1rem;
        }

        .form-label {
            font-weight: 600;
            color: #ffffff;
        }

        .form-control {
            border-radius: 8px;
            margin-bottom: 1.2rem;
            padding: 0.75rem 1rem;
            border: 1px solid #d1d5db;
        }

        .btn-login {
            width: 100%;
            background: #a42ad7;
            color: #fff;
            font-weight: bold;
            border: none;
            border-radius: 8px;
            padding: 0.75rem;
            font-size: 1.1rem;
            transition: background 0.2s;
        }

        .btn-login:hover {
            background: #0d153a;
        }

        form div {
            display: flex;
            flex-direction: column;
        }

        body {
            font-family: "Poppins", sans-serif;
        }
        @media (max-width: 767.98px) {
            .login-right {
                padding: 30px;
            }
        }
    </style>
</head>

<body>
    <div class="login-container">
        <div class="login-left d-md-block d-none">
            
            <!-- You can add an SVG or illustration here if you want -->
        </div>
        <div class="login-right">
            <div class="">
                <img src="<?php echo e(getPresignedUrl($settings->logo)); ?>" alt="Logo" class="login-logo">
                <div class="login-title">Hello, Welcome Back</div>
                <div class="login-subtitle">
                    Login with your Username and Password Credentials
                </div>
                <?php if(session('status')): ?>
                    <div class="alert alert-success" style="color: green; margin-bottom: 1rem;">
                        <?php echo e(session('status')); ?>

                    </div>
                <?php endif; ?>

                
                <form method="POST" action="<?php echo e(route('login')); ?>">
                    <?php echo csrf_field(); ?>
                    <div>
                        <label class="form-label" for="email">User Name</label>
                        <input id="email" type="text" class="form-control" name="email"
                            value="<?php echo e(old('email')); ?>" required autofocus placeholder="Enter User Name">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red; font-size: 0.95em; margin-top: -20px;">
                                <?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="form-label" for="password">Password</label>
                        <input id="password" type="password" class="form-control" name="password" required
                            placeholder="Enter Your Password">
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: red; font-size: 0.95em; margin-top: -20px;">
                                <?php echo e($message); ?>

                            </div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <button type="submit" class="btn-login">Login</button>
                </form>
            </div>
        </div>
    </div>
</body>

</html>

<?php echo $__env->make('layouts.login', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\med_exam_guru\resources\views/auth/login.blade.php ENDPATH**/ ?>