<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="container-fluid">
        <!-- Page Title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.contents.index', [$type, $subChapter->id])); ?>"><?php echo e(ucwords(str_replace('_', ' ', $type))); ?> Content</a></li>
                            <li class="breadcrumb-item active">Create</li>
                        </ol>
                    </div>
                    <?php $__env->startSection('page_title'); ?>
                        Create <?php echo e(ucwords(str_replace('_', ' ', $type))); ?> Content
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>

        <!-- Form Card -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="page-title mb-3">Create <?php echo e(ucwords(str_replace('_', ' ', $type))); ?> Content for SubChapter: <strong><?php echo e($subChapter->title); ?></strong></h4>
                        <hr>

                        <form method="POST" action="<?php echo e(route('admin.contents.store', [$type, $subChapter->id])); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="form-group">
                                <label>Title</label>
                                <input type="text" name="title" class="form-control" required>
                            </div>

                            <?php if(in_array($type, ['mcq', 'neet_pg_mcq'])): ?>

                                <div class="form-group">
                                    <label>Question<?php echo $type == 'neet_pg_mcq' ? ' <small>(Supports HTML/tables)</small>' : ''; ?></label>
                                    <textarea name="question" class="form-control" rows="4" id="editor"></textarea>
                                </div>

                                <?php if($type == 'neet_pg_mcq'): ?>
                                    <div class="form-group">
                                        <label>Image (optional)</label>
                                        <input type="file" name="image" class="form-control">
                                        <small class="text-muted">Accepted formats: jpg, png, gif (Max: 2MB)</small>
                                    </div>
                                <?php endif; ?>

                                <?php for($i = 1; $i <= 4; $i++): ?>
                                    <div class="form-group">
                                        <label>Option <?php echo e($i); ?></label>
                                        <input type="text" name="option_<?php echo e($i); ?>" class="form-control" required>
                                    </div>
                                <?php endfor; ?>

                                <div class="form-group">
                                    <label>Correct Option (1-4)</label>
                                    <input type="number" name="correct_option" min="1" max="4" class="form-control" required>
                                </div>

                                <div class="form-group">
                                    <label>Explanation</label>
                                    <textarea name="explanation" class="form-control" rows="3"></textarea>
                                </div>

                            <?php endif; ?>

                            <div class="form-group mt-4">
                                <button type="submit" class="btn btn-success">Save</button>
                                <a href="<?php echo e(route('admin.contents.index', [$type, $subChapter->id])); ?>" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/contents/create.blade.php ENDPATH**/ ?>