<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active">Subscriptions</li>
                        </ol>
                    </div>
                    <?php $__env->startSection('page_title'); ?>
                        Subscriptions
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Subscriptions Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    <?php if(Session::has('message')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <strong>Success!</strong> <?php echo e(Session::get('message')); ?>

                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <h4 class="page-title">Subscriptions</h4>
                    <hr>

                    <div class="table-responsive">
                        <table id="example" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%;">
                            <thead>
                                <tr>
                                    <th>Sr. No.</th>
                                    <th>User</th>
                                    <th>Plan</th>
                                    <th>Course</th>
                                    <th>Start Date</th>
                                    <th>End Date</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $i=0; ?>
                                <?php $__currentLoopData = $subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$i); ?></td>
                                        <td><?php echo e($subscription->user ? $subscription->user->name : 'N/A'); ?></td>
                                        <td><?php echo e($subscription->plan ? $subscription->plan->name : 'N/A'); ?></td>
                                        <td><?php echo e($subscription->course ? $subscription->course->name : 'N/A'); ?></td>
                                        <td><?php echo e($subscription->start_date->format('d M Y')); ?></td>
                                        <td><?php echo e($subscription->end_date->format('d M Y')); ?></td>
                                        <td>
                                            <?php if($subscription->status == 'active'): ?>
                                                <span class="badge badge-success">Active</span>
                                            <?php else: ?>
                                                <span class="badge badge-danger">Inactive</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('jscode'); ?>
<script>
    $('#example').DataTable({
        responsive: true
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/subscriptions/index.blade.php ENDPATH**/ ?>