<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active">SEO Settings</li>
                            </ol>
                        </div>
                    <?php $__env->startSection('page_title'); ?>
                        SEO Settings
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <?php if(Session::has('message')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> <?php echo e(Session::get('message')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title"><?php echo $__env->yieldContent('page_title'); ?></h4>
                            </div>
                            <div class="col-md-6">
                                <a href="<?php echo e(route('admin.seo_create')); ?>">
                                    <button class="btn btn-success float-right ml-2"><i class="fas fa-plus"></i>
                                        Add New SEO
                                    </button>
                                </a>
                            </div>
                        </div>
                        <hr>

                        <div class="table-responsive">
                            <table class="table table-bordered" id="seo-table"
                                class="table table-striped table-bordered dt-responsive nowrap"
                                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                <thead>
                                    <tr>
                                        <th>S No</th>
                                        <th>Created Date</th>
                                        <th>Modified Date</th>
                                        <th>Page</th>
                                        <th>Meta Title</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $seoSettings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $seo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e(date('d M Y h:i A', strtotime($seo->created_at))); ?></td>
                                            <td><?php echo e(date('d M Y h:i A', strtotime($seo->updated_at))); ?></td>
                                            <td><?php echo e($seo->page); ?></td>
                                            <td><?php echo e($seo->meta_title); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('admin.seo_edit', $seo->id)); ?>"
                                                    class="btn btn-primary btn-sm"><i class="fa fa-pen"></i></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('jscode'); ?>
<script language="javascript">
    $('#seo-table').DataTable({
        responsive: true
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/settings/seo.blade.php ENDPATH**/ ?>