<?php $__env->startSection('content'); ?>
    <div class="content">
        <div class="container-fluid">
            <!-- Page Title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.contents.index', [$type, $content->sub_chapter_id])); ?>">
                                    <?php echo e(ucwords(str_replace('_', ' ', $type))); ?> List</a></li>
                                <li class="breadcrumb-item active">Edit <?php echo e(ucwords(str_replace('_', ' ', $type))); ?></li>
                            </ol>
                        </div>
                        <?php $__env->startSection('page_title'); ?>
                            Edit <?php echo e(ucwords(str_replace('_', ' ', $type))); ?> Content
                        <?php $__env->stopSection(); ?>
                    </div>
                </div>
            </div>

            <!-- Content Form -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <h4 class="page-title">Edit <?php echo e(ucwords(str_replace('_', ' ', $type))); ?></h4>
                                </div>
                            </div>

                            <form method="POST" action="<?php echo e(route('admin.contents.update', $content->id)); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="form-group">
                                    <label>Title:</label>
                                    <input type="text" name="title" class="form-control" value="<?php echo e($content->title); ?>" required>
                                </div>

                                <?php if(in_array($type, ['mcq', 'clinical_scenario', 'neet_pg_mcq'])): ?>
                                    <?php
                                        $json = json_decode($content->text_content, true);
                                    ?>

                                    <div class="form-group">
                                        <label>Question<?php echo e($type == 'neet_pg_mcq' ? ' (Supports HTML)' : ''); ?>:</label>
                                        <textarea name="question" class="form-control" rows="4" required id="editor"><?php echo e($json['question'] ?? ''); ?></textarea>
                                    </div>

                                    <?php if($type == 'neet_pg_mcq'): ?>
                                        <div class="form-group">
                                            <label>Current Image:</label><br>
                                            <img src="<?php echo e(asset('uploads/'.$type.'/' . ($json['image'] ?? ''))); ?>" alt="MCQ Image" width="200">
                                            <!--<img src="<?php echo e(asset('uploads/notes/' . $content->image_url)); ?>" alt="MCQ Image" width="200">-->
                                        </div>

                                        <div class="form-group">
                                            <label>Change Image:</label>
                                            <input type="file" name="image" class="form-control">
                                            <small class="text-muted">Leave empty to keep existing image.</small>
                                        </div>
                                    <?php endif; ?>

                                    <?php $__currentLoopData = $json['options'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-group">
                                            <label>Option <?php echo e($index + 1); ?>:</label>
                                            <input type="text" name="option_<?php echo e($index + 1); ?>" class="form-control" value="<?php echo e($option); ?>" required>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <div class="form-group">
                                        <label>Correct Option (1-4):</label>
                                        <input type="number" name="correct_option" class="form-control" min="1" max="4" value="<?php echo e($json['correct'] ?? 1); ?>" required>
                                    </div>

                                    <div class="form-group">
                                        <label>Explanation:</label>
                                        <textarea name="explanation" class="form-control"><?php echo e($json['explanation'] ?? ''); ?></textarea>
                                    </div>
                                <?php endif; ?>

                                <button type="submit" class="btn btn-primary">Update</button>
                                <a href="<?php echo e(route('admin.contents.index', [$type, $content->sub_chapter_id])); ?>" class="btn btn-secondary">Cancel</a>
                            </form>

                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- container -->
    </div> <!-- content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/contents/edit.blade.php ENDPATH**/ ?>