<?php $__env->startSection('content'); ?>
    <div class="content">
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active">Users</li>
                            </ol>
                        </div>
                        <?php $__env->startSection('page_title'); ?>
                            Users
                        <?php $__env->stopSection(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Users Table -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <?php if(Session::has('message')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <strong>Success!</strong> <?php echo e(Session::get('message')); ?>

                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        <?php endif; ?>

                        <h4 class="page-title">Users</h4>
                        <hr>

                        <div class="table-responsive">
                            <table id="example" class="table table-striped table-bordered dt-responsive nowrap"
                                style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Sr. No.</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Mobile</th>
                                        <th>Photo</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $i=0;?>
                                    <?php $__currentLoopData = $appUser; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e(++$i); ?></td>
                                            <td><?php echo e($user->name); ?></td>
                                            <td><?php echo e($user->email); ?></td>
                                            <td><?php echo e($user->mobile_no); ?></td>
                                            <td>
                                                <?php if($user->profile_photo_url): ?>
                                                    <img src="<?php echo e(asset('uploads/' . $user->profile_photo_url)); ?>"
                                                         alt="Profile Photo" width="40" height="40"
                                                         class="rounded-circle">
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('images/default.png')); ?>"
                                                         alt="Default" width="40" height="40"
                                                         class="rounded-circle">
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <form action="<?php echo e(route('admin.appUsers.toggleStatus', $user->id)); ?>" method="POST" style="display:inline;">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PATCH'); ?>
                                                    <?php if($user->is_active): ?>
                                                        <button type="submit" class="btn btn-success btn-sm">
                                                            Active
                                                        </button>
                                                    <?php else: ?>
                                                        <button type="submit" class="btn btn-danger btn-sm">
                                                            Inactive
                                                        </button>
                                                    <?php endif; ?>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('jscode'); ?>
<script>
    $('#example').DataTable({
        responsive: true
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/app_users/index.blade.php ENDPATH**/ ?>