<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active">App Settings</li>
                            </ol>
                        </div>
                    <?php $__env->startSection('page_title'); ?>
                        App Settings
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <?php if(Session::has('message')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> <?php echo e(Session::get('message')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">App Settings</h4>
                            </div>
                        </div>
                        <hr>
                        <?php if(count($setting) > 0): ?>
                            <div class="table-responsive">
                                <table id="example" class="table table-striped table-bordered dt-responsive nowrap"
                                    style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                    
                                    <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Modified Date</th>
                                            <th>Android Latest Version No</th>
                                            <th>Android Latest Version Note</th>
                                            <th>Action</th>
                                            <th>Android Download Link</th>
                                            <th>Android Force Update Required</th>
                                            <th>Ios Latest Version No</th>
                                            <th>Ios Latest Version Note</th>
                                            <th>Ios App Download Link</th>
                                            <th>Ios Force Update Required</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $setting; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $settings): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($key + 1); ?></td>
                                                <td><?php echo e(date('d M Y h:i A', strtotime($settings->updated_at))); ?></td>
                                                <td><?php echo e($settings->android_latest_version_no); ?></td>
                                                <td><?php echo e($settings->android_latest_version_note); ?></td>
                                                <td>
                                                    <a href="<?php echo e(route('admin.app_setting.edit', [$settings->id])); ?>"
                                                        class="btn btn-primary waves-effect waves-light btn-xs"><i
                                                            class="fas fa-pen"></i></a>
                                                </td>
                                                <td><?php echo e($settings->android_download_link); ?></td>
                                                <td><?php echo e($settings->android_force_update_required); ?></td>
                                                <td><?php echo e($settings->ios_latest_version_no); ?></td>
                                                <td><?php echo e($settings->ios_latest_version_note); ?></td>
                                                <td><?php echo e($settings->ios_app_download_link); ?></td>
                                                <td><?php echo e($settings->ios_force_update_required); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <h5 align='center'>No Data Found.</h5>
                        <?php endif; ?>
                    </div>
                </div> <!-- end card -->
            </div> <!-- end col -->
        </div>
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('jscode'); ?>
<script>
    $('.cdelete').on('click', function() {
        var id = $(this).data('value');
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonColor: "#348cd4",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it!"
        }).then(function(t) {
            if (t.value == true) {
                $("#deleteform" + id).submit();
            }
        })
    });
</script>
<script language="javascript">
    $('#example').DataTable();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/app_setting/index.blade.php ENDPATH**/ ?>