<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active"><?php echo e(ucwords(str_replace('_', ' ', $type))); ?> Questions</li>
                            </ol>
                        </div>
                        <?php $__env->startSection('page_title'); ?>
                            <?php echo e(ucwords(str_replace('_', ' ', $type))); ?> Questions
                        <?php $__env->stopSection(); ?>
                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <?php if(Session::has('message')): ?>
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                    <strong>Success!</strong> <?php echo e(Session::get('message')); ?>

                                </div>
                            <?php endif; ?>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <h4 class="page-title"><?php echo e(ucwords(str_replace('_', ' ', $type))); ?> Questions</h4>
                                </div>
                                <div class="col-md-6 text-right">
                                    <a href="<?php echo e(route('admin.contents.create', [$type, $sub_chapter_id])); ?>"
                                       class="btn btn-success float-right">
                                        <i class="fas fa-plus"></i> Add <?php echo e(ucwords(str_replace('_', ' ', $type))); ?>

                                    </a>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table id="example" class="table table-striped table-bordered dt-responsive nowrap"
                                       style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Question</th>
                                            <?php if(in_array($type, ['mcq', 'neet_pg_mcq'])): ?>
                                                <th>Correct</th>
                                            <?php endif; ?>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $content): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $data = json_decode($content->text_content, true); ?>
                                            <tr>
                                                <td><?php echo e($index + 1); ?></td>
                                                <td>
                                                    <?php if($type === 'reasoning_question' && isset($data['question'])): ?>
                                                        <?php echo e(strip_tags($data['question'])); ?>

                                                    <?php else: ?>
                                                        <?php echo $content->title ?? ''; ?>

                                                    <?php endif; ?>
                                                </td>
                                                <?php if(in_array($type, ['mcq', 'neet_pg_mcq'])): ?>
                                                    <td><?php echo e($data['correct'] ?? ''); ?></td>
                                                <?php endif; ?>
                                                <td>
                                                    <a href="<?php echo e(route('admin.contents.edit', $content->id)); ?>"
                                                       class="btn btn-primary btn-xs"><i class="fas fa-pen"></i></a>

                                                    <button data-value="<?php echo e($content->id); ?>"
                                                            class="btn btn-danger btn-xs cdelete"><i class="fas fa-trash"></i></button>

                                                    <form id="deleteform<?php echo e($content->id); ?>" method="POST"
                                                          action="<?php echo e(route('admin.contents.destroy', $content->id)); ?>"
                                                          style="display: none;">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>

                        </div> <!-- end card-body -->
                    </div> <!-- end card -->
                </div> <!-- end col -->
            </div> <!-- end row -->

        </div> <!-- container -->
    </div> <!-- content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('jscode'); ?>
<script>
    $('.cdelete').on('click', function () {
        var id = $(this).data('value');
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#348cd4",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it!"
        }).then(function (result) {
            //if (result.isConfirmed) {
            if (result.value == true) {
                $('#deleteform' + id).submit();
                //document.getElementById('deleteform' + id).submit();
            }
        });
    });

    $('#example').DataTable({
        responsive: true
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/contents/index.blade.php ENDPATH**/ ?>