<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.sub_chapters.index')); ?>">Chapters</a></li>
                                <li class="breadcrumb-item active">Create Sub Chapter</li>
                            </ol>
                        </div>
                    <?php $__env->startSection('page_title'); ?>
                        Create Sub Chapter
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Create New Sub Chapter</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="<?php echo e(route('admin.sub_chapters.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" id="title" class="form-control">
                                    
                            </div>

                            <div class="form-group">
                                <label for="course_id">Course</label>
                                <select id="course_id" class="form-control" required>
                                    <option value="">-- Select Course --</option>
                                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($course->id); ?>" <?php echo e(old('course_id') == $course->id ? 'selected' : ''); ?>>
                                            <?php echo e($course->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>


                            <div class="form-group">
                                <label for="chapter_type">Chapter Type</label>
                                <select id="chapter_type" class="form-control" required>
                                    <option value="">-- Select Chapter Type --</option>
                                    <?php $__currentLoopData = chapterTypeOptions(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>">
                                            <?php echo e($label); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            

                            <div class="form-group">
                                <label for="chapter_id">Chapter</label>
                                <select name="chapter_id" id="chapter_id" class="form-control" required>
                                    <option value="">-- Select Chapter --</option>
                                </select>
                                <!-- <select name="chapter_id" id="chapter_id" class="form-control" required>
                                    <option value="">-- Select Chapter --</option>
                                    <?php $__currentLoopData = $chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($chapter->id); ?>" <?php echo e(old('chapter_id') == $chapter->id ? 'selected' : ''); ?>>
                                            <?php echo e($chapter->title); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select> -->
                            </div>
  
                            <div class="form-group">
                                <label for="is_free">Free/Paid</label>
                                <select name="is_free" id="is_free" class="form-control" required>
                                    <option value="1">Paid</option> 
                                    <option value="0">Free</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="is_favorite">Favorite</label>
                                <select name="is_favorite" id="is_favorite" class="form-control" required>
                                    <option value="1">Yes</option> 
                                    <option value="0">No</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="order_index">Chapter No.</label>
                                <input type="text" name="order_index" id="order_index" class="form-control">
                            </div>

                            <button type="submit" class="btn btn-primary">Create Sub Chapter</button>
                            <a href="<?php echo e(route('admin.sub_chapters.index')); ?>" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div> <!-- end card -->
            </div> <!-- end col -->
        </div>
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    function fetchChapters() {
        var courseId = $('#course_id').val();
        var chapterType = $('#chapter_type').val();

        if (courseId && chapterType) {
            $.ajax({
                url: "<?php echo e(route('admin.getChapters')); ?>",
                method: "GET",
                data: {
                    course_id: courseId,
                    chapter_type: chapterType
                },
                success: function(response) {
                    $('#chapter_id').empty().append('<option value="">-- Select Chapter --</option>');
                    $.each(response, function(index, chapter) {
                        $('#chapter_id').append('<option value="' + chapter.id + '">' + chapter.title + '</option>');
                    });
                }
            });
        } else {
            $('#chapter_id').empty().append('<option value="">-- Select Chapter --</option>');
        }
    }

    $(document).ready(function () {
        $('#course_id, #chapter_type').on('change', fetchChapters);
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\med_exam_guru\resources\views/admin/sub_chapters/create.blade.php ENDPATH**/ ?>