<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item"><a
                                        href="<?php echo e(route('admin.courses.index')); ?>">Courses</a></li>
                                <li class="breadcrumb-item active">Edit Course</li>
                            </ol>
                        </div>
                    <?php $__env->startSection('page_title'); ?>
                        Edit Course
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Edit Course</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="<?php echo e(route('admin.courses.update', $course)); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="form-group">
                                <label for="image">Current Image</label>
                                <div>
                                    <img src="<?php echo e(asset('uploads/courses/' . $course->image)); ?>"
                                        alt="<?php echo e($course->title); ?>" height="100">
                                </div>
                                <br>
                                <label for="image">Change Course Image</label>
                                <input type="file" name="image" id="image" class="form-control">
                                <small class="form-text text-muted">Leave blank to keep the current image. Recommended
                                    size: 1200x400px</small>
                            </div>

                            <div class="form-group">
                                <label for="title">Name</label>
                                <input type="text" name="name" id="name" class="form-control"
                                    value="<?php echo e(old('name', $course->name)); ?>">
                            </div>
                            
                             <div class="form-group">
                                <label for="fullname">Priority * :</label>
                                <input type="number" class="form-control <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="priority" id="priority"
                                    value="<?php echo e(old('priority', $course->priority ?? null)); ?>" autocomplete="off">
                                <?php $__errorArgs = ['priority'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

  
                            <div class="form-group">
                                <label for="is_active">Is Active *</label>
                                <select name="is_active" id="is_active" class="form-control" required>
                                    <option value="1" <?php echo e(old('is_active', $course->is_active) == 1 ? 'selected' : ''); ?>>
                                        Active</option>
                                    <option value="0" <?php echo e(old('is_active', $course->is_active) == 0 ? 'selected' : ''); ?>>
                                        Inactive</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Update Course</button>
                            <a href="<?php echo e(route('admin.courses.index')); ?>" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/courses/edit.blade.php ENDPATH**/ ?>