<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- Start Page Title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.sub_chapters.index')); ?>">Sub Chapters</a></li>
                                <li class="breadcrumb-item active">Edit Clinical Scenario</li>
                            </ol>
                        </div>
                        <?php $__env->startSection('page_title'); ?>
                            Edit Clinical Scenario
                        <?php $__env->stopSection(); ?>
                    </div>
                </div>
            </div>
            <!-- End Page Title -->

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <h4 class="page-title">Edit Clinical Scenario PDF</h4>
                                </div>
                            </div>
                            <hr>

                            <form method="POST" action="<?php echo e(route('admin.contents.update', $content->id)); ?>" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>

                                <div class="form-group">
                                    <label for="title">Title *</label>
                                    <input type="text" name="title" id="title" class="form-control" value="<?php echo e(old('title', $content->title)); ?>" required>
                                </div>

                               <?php if($content->pdf_url): ?>
                                    <div class="form-group">
                                        <label>Current PDF</label>
                                        <div>
                                            <a href="<?php echo e(asset('uploads/clinical_scenario/' . $content->pdf_url)); ?>" target="_blank">
                                                View current PDF
                                            </a>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="form-group">
                                    <label for="file">Upload New PDF</label>
                                    <input type="file" name="file" id="file" class="form-control">
                                    <small class="form-text text-muted">Leave blank to keep the current PDF. Max size: 5MB</small>
                                </div>

                                <button type="submit" class="btn btn-primary">Update Clinical Scenario</button>
                                <a href="<?php echo e(route('admin.sub_chapters.index')); ?>" class="btn btn-secondary">Cancel</a>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div> <!-- container -->
    </div> <!-- content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/contents/edit_clinical_scenario.blade.php ENDPATH**/ ?>