<?php $__env->startSection('content'); ?>
<div class="content">
    <div class="container-fluid">
        <!-- Page Title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.college_contents.index', [$college->id])); ?>"> Content</a></li>
                            <li class="breadcrumb-item active">Create</li>
                        </ol>
                    </div>
                    <?php $__env->startSection('page_title'); ?>
                        Create Content
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>

        <!-- Form Card -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="page-title mb-3">Create Content for College: <strong><?php echo e($college->title); ?></strong></h4>
                        <hr>

                        <form method="POST" action="<?php echo e(route('admin.college_contents.store', [$college->id])); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="form-group">
                                <label>Title</label>
                                <input type="text" name="title" class="form-control" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="file">Upload New PDF</label>
                                <input type="file" name="file" id="file" class="form-control">
                                <small class="form-text text-muted">Leave blank to keep the current PDF. Max size: 5MB</small>
                            </div>
                                

                            <div class="form-group mt-4">
                                <button type="submit" class="btn btn-success">Save</button>
                                <a href="<?php echo e(route('admin.college_contents.index', [$college->id])); ?>" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/college_contents/create.blade.php ENDPATH**/ ?>