<?php $__env->startSection('content'); ?>
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="<?php echo e(route('admin.seo_settings')); ?>">SEO Settings</a></li>
                                <li class="breadcrumb-item active">SEO Settings</li>
                            </ol>
                        </div>
                    <?php $__env->startSection('page_title'); ?>
                        SEO Settings
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <?php if(Session::has('message')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> <?php echo e(Session::get('message')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">SEO Settings</h4>
                            </div>
                        </div>
                        <hr>
                        <form id="form" method="post" action="<?php echo e(route('admin.seo_update', [$seo->id])); ?>"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="url" value="<?php echo e(URL::previous()); ?>">
                            <div class="form-group">
                                <label for="fullname">Meta Title :</label>
                                <input type="text" class="form-control" name="meta_title" id="meta_title"
                                    value="<?php echo e(old('meta_title', $seo->meta_title ?? null)); ?>" autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Meta Keywords :</label>
                                <input type="text" class="form-control" name="meta_keywords" id="meta_keywords"
                                    value="<?php echo e(old('meta_keywords', $seo->meta_keywords ?? null)); ?>"
                                    data-role="tagsinput" autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Meta Description :</label>
                                <textarea id="meta_description" class="form-control" name="meta_description" rows="3"><?php echo e(old('meta_description', $seo->meta_description ?? null)); ?></textarea>
                            </div>
                            <div class="form-group mb-0">
                                <input type="submit" name="submit" class="btn btn-success" value="Submit">
                            </div>
                        </form>
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/settings/seo_edit.blade.php ENDPATH**/ ?>