<?php $__env->startSection('content'); ?>
<div class="content">
    <!-- Start Content-->
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.plans.index')); ?>">Plan</a></li>
                            <li class="breadcrumb-item active">Create Plan</li>
                        </ol>
                    </div>
                    <?php $__env->startSection('page_title'); ?>
                        Create Plan
                    <?php $__env->stopSection(); ?>
                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <h4 class="page-title">Create New Plan</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="<?php echo e(route('admin.plans.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <!-- Name -->
                            <div class="form-group">
                                <label for="name">Name</label>
                                <input type="text" name="name" id="name" class="form-control"
                                    value="<?php echo e(old('name')); ?>" required>
                            </div>

                            <!-- Price -->
                            <div class="form-group">
                                <label for="price">Price</label>
                                <input type="number" name="price" id="price" class="form-control" step="0.01" min="0"
                                    value="<?php echo e(old('price')); ?>" required>
                            </div>

                            <!-- Billing Cycle -->
                            <div class="form-group">
                                <label for="billing_cycle">Billing Cycle</label>
                                <select name="billing_cycle" id="billing_cycle" class="form-control" required>
                                    <option value="">Select Billing Cycle</option>
                                    <option value="month" <?php echo e(old('billing_cycle') == 'month' ? 'selected' : ''); ?>>Month</option>
                                    <option value="year" <?php echo e(old('billing_cycle') == 'year' ? 'selected' : ''); ?>>Year</option>
                                </select>
                            </div>

                            <!-- Submit -->
                            <button type="submit" class="btn btn-primary">Create Plan</button>
                            <a href="<?php echo e(route('admin.plans.index')); ?>" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div> <!-- end card -->
            </div> <!-- end col -->
        </div>
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/medexamgurucolor/public_html/med_exam_guru/resources/views/admin/plans/create.blade.php ENDPATH**/ ?>