<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\AdminAppSplashScreensController;
use App\Http\Controllers\Admin\AdminBannerController;
use App\Http\Controllers\Admin\CourseController;
use App\Http\Controllers\Admin\CollegeController;
use App\Http\Controllers\Admin\ChapterController;
use App\Http\Controllers\Admin\ContentController;
use App\Http\Controllers\Admin\CollegeContentController;
use App\Http\Controllers\Admin\SubChapterController;
use App\Http\Controllers\Admin\AdminSettingsController;
use App\Http\Controllers\Admin\AdminAppSettingController;
use App\Http\Controllers\Admin\PlanController;
use App\Http\Controllers\Admin\StaticPageController;
use App\Http\Controllers\Admin\PlanFeatureController;
use App\Http\Controllers\Admin\AppUserController;
use App\Http\Controllers\Admin\SubscriptionController;
use App\Http\Controllers\Admin\FeedbackController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

// Ensure 'auth' middleware is applied and ideally a custom 'admin' middleware/gate
Route::middleware(['auth', 'can:isAdmin'])->prefix('admin')->name('admin.')->group(function () {
    // Admin Dashboard
    
    Route::get('/users', [AppUserController::class, 'index'])->name('appUsers.index');
    Route::patch('/users/{id}/status', [AppUserController::class, 'toggleStatus'])->name('appUsers.toggleStatus');
    Route::get('/subscriptions', [SubscriptionController::class, 'index'])->name('subscriptions.index');
     
    Route::get('/', [AdminDashboardController::class, 'index'])->name('dashboard');
    Route::resource('profile', ProfileController::class);
    Route::resource('app_splash_screens', AdminAppSplashScreensController::class);
    Route::resource('banners', AdminBannerController::class);
    Route::resource('courses', CourseController::class);
    Route::resource('plans', PlanController::class);
    Route::resource('static_pages', StaticPageController::class);
    Route::resource('colleges', CollegeController::class);
    Route::resource('chapters', ChapterController::class);
    Route::resource('sub_chapters', SubChapterController::class);

    // Route to handle note editing (single-entry type)
    Route::get('contents/{content}/edit', [ContentController::class, 'edit'])->name('contents.edit');
    // Route to handle update
    Route::put('contents/{content}', [ContentController::class, 'update'])->name('contents.update');

    // Route to handle delete
    Route::delete('contents/{content}', [ContentController::class, 'destroy'])->name('contents.destroy');

    Route::get('contents/{type}/{sub_chapter_id}', [ContentController::class, 'entry'])->name('contents.entry');

    // Route to list contents like MCQ, clinical_scenario
    Route::get('contents/{type}/{sub_chapter_id}/list', [ContentController::class, 'index'])->name('contents.index');

    // Route to show create form
    Route::get('contents/{type}/{sub_chapter_id}/create', [ContentController::class, 'create'])->name('contents.create');

    // Route to handle creation
    Route::post('contents/{type}/{sub_chapter_id}', [ContentController::class, 'store'])->name('contents.store');

    // college content routes

    Route::get('college_contents/{content}/edit', [CollegeContentController::class, 'edit'])->name('college_contents.edit');
    Route::put('college_contents/{content}', [CollegeContentController::class, 'update'])->name('college_contents.update');
    Route::delete('college_contents/{content}', [CollegeContentController::class, 'destroy'])->name('college_contents.destroy');
    Route::get('college_contents/{college_id}/list', [CollegeContentController::class, 'index'])->name('college_contents.index');
    Route::get('college_contents/{college_id}/create', [CollegeContentController::class, 'create'])->name('college_contents.create');
    Route::post('college_contents/{college_id}', [CollegeContentController::class, 'store'])->name('college_contents.store');

    // Feature list for a plan
    Route::get('plan_features/{plan_id}/list', [PlanFeatureController::class, 'index'])->name('plan_features.index');

    // Create feature
    Route::get('plan_features/{plan_id}/create', [PlanFeatureController::class, 'create'])->name('plan_features.create');
    Route::post('plan_features/{plan_id}', [PlanFeatureController::class, 'store'])->name('plan_features.store');

    // Edit/update/delete feature
    Route::get('plan_features/{plan_feature}/edit', [PlanFeatureController::class, 'edit'])->name('plan_features.edit');
    Route::put('plan_features/{plan_feature}', [PlanFeatureController::class, 'update'])->name('plan_features.update');
    Route::delete('plan_features/{plan_feature}', [PlanFeatureController::class, 'destroy'])->name('plan_features.destroy');

    Route::get('/feedbacks', [FeedbackController::class, 'index'])->name('feedbacks.index');
    Route::delete('/feedbacks/{id}', [FeedbackController::class, 'destroy'])->name('feedbacks.destroy');
    Route::get('/get-chapters', [SubChapterController::class, 'getChapters'])->name('getChapters');
    Route::get('general_settings', [AdminSettingsController::class, 'general_settings'])->name('general_settings');
    Route::get('seo-settings', [AdminSettingsController::class, 'seo_settings'])->name('seo_settings');
    Route::get('seo-settings/create', [AdminSettingsController::class, 'seo_create'])->name('seo_create');
    Route::post('seo-settings/store', [AdminSettingsController::class, 'seo_store'])->name('seo_store');
    Route::get('seo-settings/edit/{id}', [AdminSettingsController::class, 'seo_edit'])->name('seo_edit');
    Route::post('seo-settings/update/{id}', [AdminSettingsController::class, 'seo_update'])->name('seo_update');
    Route::get('sm_settings', [AdminSettingsController::class, 'sm_settings'])->name('sm_settings');
    Route::post('settings/general_update/{id}', [AdminSettingsController::class, 'general_update'])->name('settings.general_update');
    Route::post('settings/sm_update/{id}', [AdminSettingsController::class, 'sm_update'])->name('settings.sm_update');
    Route::resource('admin/app_setting', AdminAppSettingController::class);
});
