<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AppSplashScreensController;
use App\Http\Controllers\Api\AppAuthController;
use App\Http\Controllers\Api\CourseController;
use App\Http\Controllers\Api\FeedbackController;
use App\Http\Controllers\Api\PlanController;
use App\Http\Controllers\Api\NotificationController;
use App\Http\Controllers\Api\PaymentController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::prefix('v1')->group(function () {
    Route::get('app-splash-screens', [AppSplashScreensController::class, 'app_splash_screens']);
    Route::get('banners', [AppSplashScreensController::class, 'banners']);
});

// Add this to your routes/api.php for testing
Route::get('/test-razorpay', function() {
    try {
        $api = new \Razorpay\Api\Api('test_key', 'test_secret');
        return response()->json(['status' => 'Razorpay class loaded successfully']);
    } catch (\Exception $e) {
        return response()->json(['error' => $e->getMessage()]);
    }
});

Route::post('/send-otp', [AppAuthController::class, 'sendOtp']);
Route::post('/verify-otp', [AppAuthController::class, 'verifyOtp']);
Route::post('/register', [AppAuthController::class, 'register']);
Route::get('/colleges', [AppAuthController::class, 'colleges']);
Route::get('/popular-chapters', [CourseController::class, 'popularChapters']);

Route::middleware('auth:sanctum')->group(function () {

    Route::post('/profile-update', [AppAuthController::class, 'profileUpdate']);
    Route::get('/courses', [CourseController::class, 'index']);
    Route::get('/search-courses', [CourseController::class, 'searchCourses']);
    Route::get('/chapters', [CourseController::class, 'chapters']);
    Route::get('/sub-chapters', [CourseController::class, 'subChapters']);
    Route::get('/contents', [CourseController::class, 'contents']);
    Route::post('/submit-content', [CourseController::class, 'submitContent']);
    Route::post('/feedback', [FeedbackController::class, 'store']);
    Route::get('/past-papers', [CourseController::class, 'pastPapers']);
    Route::get('/past-papers-detail', [CourseController::class, 'pastPapersDetail']);
    Route::get('/plans', [PlanController::class, 'index']);
    Route::get('/notifications', [NotificationController::class, 'index']);
    Route::post('/subscribe-now', [PlanController::class, 'subscribeNow']);
    Route::get('/subscription', [PlanController::class, 'subscription']);
    Route::get('/static-page', [AppSplashScreensController::class, 'staticPage']);
    Route::get('/favorites', [FeedbackController::class, 'favorites']);
    Route::post('/favorite-create', [FeedbackController::class, 'favoriteCreate']);
    Route::post('/logout', [AppAuthController::class, 'logout']);
    
    Route::post('/payment/order', [PaymentController::class, 'createOrder']);
    Route::post('/payment/verify', [PaymentController::class, 'verifyPayment']);
    
    Route::delete('/delete-account', [AppAuthController::class, 'deleteAccount']);


});
