@extends('admin.layouts.main')

@section('content')
<div class="content">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">Subscriptions</li>
                        </ol>
                    </div>
                    @section('page_title')
                        Subscriptions
                    @endsection
                </div>
            </div>
        </div>
    </div>

    <!-- Subscriptions Table -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">

                    @if (Session::has('message'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <strong>Success!</strong> {{ Session::get('message') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif

                    <h4 class="page-title">Subscriptions</h4>
                    <hr>

                    <div class="table-responsive">
                        <table id="example" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%;">
                            <thead>
                                <tr>
                                    <th>Sr. No.</th>
                                    <th>User</th>
                                    <th>Plan</th>
                                    <th>Course</th>
                                    <th>Start Date</th>
                                    <th>End Date</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php $i=0; @endphp
                                @foreach ($subscriptions as $subscription)
                                    <tr>
                                        <td>{{ ++$i }}</td>
                                        <td>{{ $subscription->user ? $subscription->user->name : 'N/A' }}</td>
                                        <td>{{ $subscription->plan ? $subscription->plan->name : 'N/A' }}</td>
                                        <td>{{ $subscription->course ? $subscription->course->name : 'N/A' }}</td>
                                        <td>{{ $subscription->start_date->format('d M Y') }}</td>
                                        <td>{{ $subscription->end_date->format('d M Y') }}</td>
                                        <td>
                                            @if ($subscription->status == 'active')
                                                <span class="badge badge-success">Active</span>
                                            @else
                                                <span class="badge badge-danger">Inactive</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('jscode')
<script>
    $('#example').DataTable({
        responsive: true
    });
</script>
@endsection
