@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item active">Sub Chapters</li>
                            </ol>
                        </div>
                    @section('page_title')
                        Sub Chapters
                    @endsection
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        @if (Session::has('message'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> {{ Session::get('message') }}
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Sub Chapters</h4>
                            </div>
                            <div class="col-md-6">
                                <a href="{{ route('admin.sub_chapters.create') }}">
                                    <button class="btn btn-success float-right ml-2"><i class="fas fa-plus"></i>
                                        Create Sub Chapter
                                    </button>
                                </a>
                            </div>
                        </div>
                        <hr>
                        <div class="table-responsive">
                            <table id="example" class="table table-striped table-bordered dt-responsive nowrap"
                                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                <thead>
                                    <tr>
                                        <th>Sr. No.</th>
                                        <th>Chapter Title</th>
                                        <th>Sub Chapter Title</th>
                                        <th>Course</th>
                                        <th>Type</th>
                                        <th>Free/Paid</th>
                                        <th>Chapter No.</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $i=0; @endphp 
                                    @foreach ($sub_chapter as $sub_chapter_data)
                                        @php $i++;$type = $sub_chapter_data->chapter->chapter_type; @endphp 
                                        <tr>
                                            <td>{{ $i }}</td>
                                            <td>{{ $sub_chapter_data->chapter->title }}</td>
                                            <td>{{ $sub_chapter_data->title }}</td>
                                            <td>{{ $sub_chapter_data->chapter->course?->name }}</td>
                                            <td>{{ $sub_chapter_data->chapter->chapter_type_label }}</td>
                                            <td>
                                                @if ($sub_chapter_data->is_free==0)
                                                <span class="badge badge-success">Paid</span>
                                                @else
                                                <span class="badge badge-danger">Free</span>
                                                @endif
                                            </td>
                                            <td>Chapter {{ $sub_chapter_data->order_index }}</td>
                                            <td>
                                                <a href="{{ route('admin.sub_chapters.edit', [$sub_chapter_data->id]) }}"
                                                    class="btn btn-primary waves-effect waves-light btn-xs"><i
                                                        class="fas fa-pen"></i></a>
                                                <button data-value="{{ $sub_chapter_data->id }}"
                                                    class="btn btn-danger waves-effect waves-light btn-xs cdelete">
                                                    <i class="fas fa-trash"></i></button>
                                                <form id="deleteform{{ $sub_chapter_data->id }}" method="post"
                                                    action="{{ route('admin.sub_chapters.destroy', [$sub_chapter_data->id]) }}">
                                                    @csrf
                                                    {{ method_field('DELETE') }}
                                                </form>
                                               @if (in_array($type, ['note', 'clinical_scenario']))
                                                    <a href="{{ route('admin.contents.entry', [$type, $sub_chapter_data->id]) }}"
                                                        class="btn btn-outline-primary btn-xs mt-1"><i
                                                        class="fas fa-file-alt"></i></a>
                                                @else
                                                    <a href="{{ route('admin.contents.index', [$type, $sub_chapter_data->id]) }}"
                                                        class="btn btn-outline-info btn-xs mt-1"><i
                                                        class="fas fa-file-alt"></i></a>
                                                @endif

                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('jscode')
<script>
    $('.cdelete').on('click', function() {
        var id = $(this).data('value');
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonColor: "#348cd4",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it!"
        }).then(function(t) {
            if (t.value == true) {
                $("#deleteform" + id).submit();
            }
        })
    });
</script>
<script language="javascript">
    $('#example').DataTable({
        responsive: true,
        columnDefs: [
            { responsivePriority: 1, targets: 0 }, // keep S.No visible
            { responsivePriority: 2, targets: -1 }, // keep Action visible
            { orderable: false, targets: -1 } // prevent sorting on Action column
        ]
    });
</script>
@endsection
