@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a
                                        href="{{ route('admin.sub_chapters.index') }}">Sub Chapter</a></li>
                                <li class="breadcrumb-item active">Edit Sub Chapter</li>
                            </ol>
                        </div>
                    @section('page_title')
                        Edit Sub Chapter
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Edit Sub Chapter</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="{{ route('admin.sub_chapters.update', $sub_chapter) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" id="title" class="form-control"
                                    value="{{ old('title', $sub_chapter->title) }}" required>
                            </div>

                             <div class="form-group">
                                <label for="course_id">Course</label>
                                <select name="course_id" id="course_id" class="form-control" required>
                                    <option value="">-- Select Course --</option>
                                    @foreach ($courses as $course)
                                        <option value="{{ $course->id }}" {{ (old('course_id', $sub_chapter->chapter->course_id) == $course->id) ? 'selected' : '' }}>
                                            {{ $course->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group" id="chapter_type_group">
                                <label for="chapter_type">Chapter Type</label>
                                <select name="chapter_type" id="chapter_type" class="form-control">
                                    <option value="">-- Select Chapter Type --</option>
                                    @foreach (chapterTypeOptions() as $key => $label)
                                        <option value="{{ $key }}"
                                            {{ old('chapter_type', $sub_chapter->chapter->chapter_type ?? '') == $key ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </select>
                                <input type="hidden" name="forced_chapter_type" id="forced_chapter_type">
                            </div>
                            
                            <div class="form-group">
                                <label for="chapter_id">Chapter</label>
                                <select name="chapter_id" id="chapter_id" class="form-control" required>
                                    <option value="">-- Select Chapter --</option>
                                </select>
                            </div>



  
                            <div class="form-group">
                                <label for="is_free">Free/Paid</label>
                                <select name="is_free" id="is_free" class="form-control" required>
                                    <option value="0" {{ old('is_free', $sub_chapter->is_free) == 0 ? 'selected' : '' }}>
                                        Paid</option>
                                    <option value="1" {{ old('is_free', $sub_chapter->is_free) == 1 ? 'selected' : '' }}>
                                        Free</option>
                                </select>
                            </div>

                            <!--<div class="form-group">-->
                            <!--    <label for="is_favorite">Favorite</label>-->
                            <!--    <select name="is_favorite" id="is_favorite" class="form-control" required>-->
                            <!--        <option value="1" {{ old('is_favorite', $sub_chapter->is_favorite) == 1 ? 'selected' : '' }}>Yes</option> -->
                            <!--        <option value="0" {{ old('is_favorite', $sub_chapter->is_favorite) == 0 ? 'selected' : '' }}>No</option>-->
                            <!--    </select>-->
                            <!--</div>-->

                            <div class="form-group">
                                <label for="order_index">Chapter No.</label>
                                <input type="text" name="order_index" id="order_index" class="form-control"
                                    value="{{ old('order_index', $sub_chapter->order_index) }}">
                            </div>

                            <button type="submit" class="btn btn-primary">Update Sub Chapter</button>
                            <a href="{{ route('admin.sub_chapters.index') }}" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
function fetchChapters(preselectedChapterId = null) {
    const courseId = $('#course_id').val();
    const chapterType = $('#forced_chapter_type').val() || $('#chapter_type').val();

    if (courseId && chapterType) {
        $.ajax({
            url: "{{ route('admin.getChapters') }}",
            method: "GET",
            data: { course_id: courseId, chapter_type: chapterType },
            success: function(response) {
                $('#chapter_id').empty().append('<option value="">-- Select Chapter --</option>');
                $.each(response, function(index, chapter) {
                    const selected = chapter.id == preselectedChapterId ? 'selected' : '';
                    $('#chapter_id').append(`<option value="${chapter.id}" ${selected}>${chapter.title}</option>`);
                });
            }
        });
    } else {
        $('#chapter_id').empty().append('<option value="">-- Select Chapter --</option>');
    }
}

function checkCourseName(preselectedChapterId = null) {
    const courseText = $('#course_id option:selected').text().toLowerCase();

    if (courseText.includes("neet pg mcq")) {
        // Force Neet PG MCQ
        $('#chapter_type_group').hide();
        $('#chapter_type').val("neet_pg_mcq");
        $('#forced_chapter_type').val("neet_pg_mcq");
    } else {
        // Show chapter type for other courses
        $('#chapter_type_group').show();
        $('#forced_chapter_type').val("");
        // Keep chapter_type selected if already chosen
    }

    fetchChapters(preselectedChapterId);
}

$(document).ready(function () {
    const initialChapterId = "{{ old('chapter_id', $sub_chapter->chapter_id) }}";

    // Load chapters on page load
    checkCourseName(initialChapterId);

    // Reload chapters on dropdown change
    $('#course_id, #chapter_type').on('change', function() {
        checkCourseName();
    });
});
</script>

@endsection
