@extends('admin.layouts.main')

@section('content')
<div class="content">
    <!-- Start Content-->
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.static_pages.index') }}">Static Pages</a></li>
                            <li class="breadcrumb-item active">Create Static Page</li>
                        </ol>
                    </div>
                    @section('page_title')
                        Create Static Page
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <h4 class="page-title">Create New Static Page</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="{{ route('admin.static_pages.store') }}" method="POST">
                            @csrf

                            <!-- Title -->
                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" id="title" class="form-control"
                                    value="{{ old('title') }}" required>
                            </div>

                            <!-- Sub Title -->
                            <div class="form-group">
                                <label for="sub_title">Sub Title</label>
                                <input type="text" name="sub_title" id="sub_title" class="form-control"
                                    value="{{ old('sub_title') }}">
                            </div>

                            <!-- Description -->
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea name="description" id="editor" rows="5" class="form-control">{{ old('description') }}</textarea>
                            </div>

                            <!-- Submit -->
                            <button type="submit" class="btn btn-primary">Create Static Page</button>
                            <a href="{{ route('admin.static_pages.index') }}" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div> <!-- end card -->
            </div> <!-- end col -->
        </div>
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
@endsection
