@extends('admin.layouts.main')
@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item active">Social Media Settings</li>
                            </ol>
                        </div>
                    @section('page_title')
                        Social Media Settings
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        @if (Session::has('message'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> {{ Session::get('message') }}
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Social Media Settings</h4>
                            </div>
                        </div>
                        <hr>
                        <form id="form" method="post" action="{{ route('admin.settings.sm_update', [$settings->id]) }}"
                            enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="url" value="{{ URL::previous() }}">
                            <div class="form-group">
                                <label for="fullname">Facebook :</label>
                                <input type="text" class="form-control" name="facebook" id="facebook"
                                    value="{{ old('facebook', $settings->facebook ?? null) }}" autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Linkedin :</label>
                                <input type="text" class="form-control" name="linkedin" id="linkedin"
                                    value="{{ old('linkedin', $settings->linkedin ?? null) }}" autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Twitter :</label>
                                <input type="text" class="form-control" name="twitter" id="twitter"
                                    value="{{ old('twitter', $settings->twitter ?? null) }}" autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Youtube :</label>
                                <input type="text" class="form-control" name="youtube" id="youtube"
                                    value="{{ old('youtube', $settings->youtube ?? null) }}" autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Instagram :</label>
                                <input type="text" class="form-control" name="instagram" id="instagram"
                                    value="{{ old('instagram', $settings->instagram ?? null) }}" autocomplete="off">
                            </div>
                            <div class="form-group mb-0">
                                <input type="submit" name="submit" class="btn btn-success" value="Submit">
                            </div>
                        </form>
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
@endsection
