@extends('admin.layouts.main')
@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('admin.seo_settings') }}">SEO Settings</a></li>
                                <li class="breadcrumb-item active">SEO Settings</li>
                            </ol>
                        </div>
                    @section('page_title')
                        SEO Settings
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        @if (Session::has('message'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> {{ Session::get('message') }}
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">SEO Settings</h4>
                            </div>
                        </div>
                        <hr>
                        <form id="form" method="post" action="{{ route('admin.seo_update', [$seo->id]) }}"
                            enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="url" value="{{ URL::previous() }}">
                            <div class="form-group">
                                <label for="fullname">Meta Title :</label>
                                <input type="text" class="form-control" name="meta_title" id="meta_title"
                                    value="{{ old('meta_title', $seo->meta_title ?? null) }}" autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Meta Keywords :</label>
                                <input type="text" class="form-control" name="meta_keywords" id="meta_keywords"
                                    value="{{ old('meta_keywords', $seo->meta_keywords ?? null) }}"
                                    data-role="tagsinput" autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Meta Description :</label>
                                <textarea id="meta_description" class="form-control" name="meta_description" rows="3">{{ old('meta_description', $seo->meta_description ?? null) }}</textarea>
                            </div>
                            <div class="form-group mb-0">
                                <input type="submit" name="submit" class="btn btn-success" value="Submit">
                            </div>
                        </form>
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <!-- end row -->
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
@endsection
