@extends('admin.layouts.main')
@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item active">Genreal Settings</li>
                            </ol>
                        </div>
                    @section('page_title')
                        General Settings
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        @if (Session::has('message'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> {{ Session::get('message') }}
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">General Settings</h4>
                            </div>
                        </div>
                        <hr>

                        <form id="form" method="post"
                            action="{{ route('admin.settings.general_update', [$settings->id]) }}"
                            enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="url" value="{{ URL::previous() }}">
                            <div class="form-group">
                                <label for="fullname">Site Name * :</label>
                                <input type="text" class="form-control @error('site_name') is-invalid @enderror"
                                    name="site_name" id="site_name"
                                    value="{{ old('name', $settings->site_name ?? null) }}" required autocomplete="off">
                                @error('site_name')
                                    <div class="alert alert-danger bg-transparent text-danger alert-dismissible fade show"
                                        role="alert">
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Address :</label>
                                <textarea id="address" class="form-control" name="address" rows="3">{{ old('address', $settings->address ?? null) }}</textarea>
                            </div>
                             <div class="form-group">
                                <label for="latitude">Latitude :</label>
                                <input type="text" class="form-control" name="latitude" id="latitude"
                                    value="{{ old('latitude', $settings->latitude ?? null) }}" autocomplete="off">
                            </div>

                            <div class="form-group">
                                <label for="longitude">Longitude :</label>
                                <input type="text" class="form-control" name="longitude" id="longitude"
                                    value="{{ old('longitude', $settings->longitude ?? null) }}" autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Email * :</label>
                                <input type="email" class="form-control @error('email') is-invalid @enderror"
                                    name="email" id="email" value="{{ old('email', $settings->email ?? null) }}"
                                    required autocomplete="off">
                                @error('email')
                                    <div class="alert alert-danger bg-transparent text-danger alert-dismissible fade show"
                                        role="alert">
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Alternative Email :</label>
                                <input type="email" class="form-control" name="alternative_email"
                                    id="alternative_email"
                                    value="{{ old('alternative_email', $settings->alternative_email ?? null) }}"
                                    autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Virtual Number * :</label>
                                <input type="text" class="form-control @error('phone') is-invalid @enderror"
                                    name="phone" id="phone" value="{{ old('phone', $settings->phone ?? null) }}"
                                    required autocomplete="off">
                                @error('phone')
                                    <div class="alert alert-danger bg-transparent text-danger alert-dismissible fade show"
                                        role="alert">
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Mobile Number * :</label>
                                <input type="text" class="form-control @error('mobile_number') is-invalid @enderror"
                                    name="mobile_number" id="mobile_number"
                                    value="{{ old('mobile_number', $settings->alternative_number ?? null) }}"
                                    autocomplete="off">
                                @error('mobile_number')
                                    <div class="alert alert-danger bg-transparent text-danger alert-dismissible fade show"
                                        role="alert">
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Working Days :</label>
                                <input type="text" class="form-control" name="working_days" id="working_days"
                                    value="{{ old('working_days', $settings->working_days ?? null) }}"
                                    autocomplete="off">
                            </div>
                            <div class="form-group">
                                <label for="fullname">Logo :</label>
                                <input type="file" name="logo" class="dropify" accept="image/*"
                                    @if (isset($settings->logo)) data-default-file="{{ getPresignedUrl($settings->logo) }}" @endif>
                            </div>
                            <div class="form-group">
                                <label for="fullname">Favicon :</label>
                                <input type="file" name="favicon" class="dropify" accept="image/*"
                                    @if (isset($settings->favicon)) data-default-file="{{ getPresignedUrl($settings->favicon) }}" @endif>
                                @error('favicon')
                                    <span class="invalid-feedback" role="alert" style="display: block;">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="android_app">Android App Link :</label>
                                <input type="text" class="form-control" name="android_app_link"
                                    id="android_app_link"
                                    value="{{ old('android_app_link', $settings->android_app_link ?? null) }}"
                                    autocomplete="off">
                            </div>
                            {{-- <div class="form-group">
                                <label for="ios_app_link">Ios App Link :</label>
                                <input type="text" class="form-control" name="ios_app_link" id="ios_app_link"
                                    value="{{ old('ios_app_link', $settings->ios_app_link ?? null) }}"
                                    autocomplete="off">
                            </div> --}}
                            {{-- <div class="form-group">
                                <label for="fullname">Youtube Video Upload Instructions :</label>
                                <textarea id="youtube_video_instructions" class="form-control ck_editor" name="youtube_video_instructions"
                                    rows="3">{{ old('youtube_video_instructions', $settings->youtube_video_instructions ?? null) }}</textarea>
                            </div> --}}
                            <div class="form-group mb-0">
                                <input type="submit" name="submit" class="btn btn-success" value="Submit">
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div> <!-- end col -->
    </div>
    <!-- end row -->
</div> <!-- end container-fluid -->

@endsection
@section('jscode')
<script>
    ClassicEditor
        .create(document.querySelector('.ck_editor'))
        .catch(error => {
            console.error(error);
        });
</script>
@endsection
