@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item active">Plans</li>
                            </ol>
                        </div>
                        @section('page_title')
                            Plans
                        @endsection
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        @if (Session::has('message'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> {{ Session::get('message') }}
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Plans</h4>
                            </div>
                            <div class="col-md-6">
                                <a href="{{ route('admin.plans.create') }}">
                                    <button class="btn btn-success float-right ml-2"><i class="fas fa-plus"></i>
                                        Create Plan
                                    </button>
                                </a>
                            </div>
                        </div>
                        <hr>
                        <div class="table-responsive">
                            <table id="example" class="table table-striped table-bordered dt-responsive nowrap"
                                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                <thead>
                                    <tr>
                                        <th>Sr. No.</th>
                                        <th>Name</th>
                                        <th>Price</th>
                                        <th>Billing Cycle</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $i=0; @endphp 
                                    @foreach ($plans as $plan)
                                        @php $i++; @endphp 
                                        <tr>
                                            <td>{{ $i }}</td>
                                            <td>{{ $plan->name }}</td>
                                            <td>₹ {{ number_format($plan->price, 0) }}</td>
                                            <td>{{ ucfirst($plan->billing_cycle) }}</td>
                                            <td>
                                                <a href="{{ route('admin.plans.edit', [$plan->id]) }}"
                                                    class="btn btn-primary waves-effect waves-light btn-xs"><i
                                                        class="fas fa-pen"></i></a>
                                                <button data-value="{{ $plan->id }}"
                                                    class="btn btn-danger waves-effect waves-light btn-xs cdelete">
                                                    <i class="fas fa-trash"></i></button>
                                                <form id="deleteform{{ $plan->id }}" method="post"
                                                    action="{{ route('admin.plans.destroy', [$plan->id]) }}">
                                                    @csrf
                                                    {{ method_field('DELETE') }}
                                                </form>
                                                <a href="{{ route('admin.plan_features.index', [$plan->id]) }}"
                                                        class="btn btn-outline-info btn-xs mt-1"><i
                                                        class="fas fa-file-alt"></i></a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('jscode')
<script>
    $('.cdelete').on('click', function() {
        var id = $(this).data('value');
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonColor: "#348cd4",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it!"
        }).then(function(t) {
            if (t.value == true) {
                $("#deleteform" + id).submit();
            }
        })
    });
</script>
<script language="javascript">
    $('#example').DataTable({
        responsive: true
    });
</script>
@endsection
