@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('admin.plans.index') }}">Plans</a></li>
                                <li class="breadcrumb-item active">Edit Plan</li>
                            </ol>
                        </div>
                        @section('page_title')
                            Edit Plan
                        @endsection
                    </div>
                </div>
            </div>
        </div>
        <!-- end page title -->

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <h4 class="page-title">Edit Plan</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="{{ route('admin.plans.update', $plan) }}" method="POST">
                            @csrf
                            @method('PUT')

                            <!-- Name -->
                            <div class="form-group">
                                <label for="name">Name</label>
                                <input type="text" name="name" id="name" class="form-control"
                                    value="{{ old('name', $plan->name) }}" required>
                            </div>

                            <!-- Price -->
                            <div class="form-group">
                                <label for="price">Price</label>
                                <input type="number" name="price" id="price" class="form-control" step="0.01" min="0"
                                    value="{{ old('price', $plan->price) }}" required>
                            </div>

                            <!-- Billing Cycle -->
                            <div class="form-group">
                                <label for="billing_cycle">Billing Cycle</label>
                                <select name="billing_cycle" id="billing_cycle" class="form-control" required>
                                    <option value="">Select Billing Cycle</option>
                                    <option value="month" {{ old('billing_cycle', $plan->billing_cycle) == 'month' ? 'selected' : '' }}>Month</option>
                                    <option value="year" {{ old('billing_cycle', $plan->billing_cycle) == 'year' ? 'selected' : '' }}>Year</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Update Plan</button>
                            <a href="{{ route('admin.plans.index') }}" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div> <!-- end card -->
            </div> <!-- end col -->
        </div>
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
@endsection
