@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <div class="container-fluid">
            <!-- Page Title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('admin.plan_features.index', ['plan_id' => $plan_feature->plan_id]) }}">
                                     List</a></li>
                                <li class="breadcrumb-item active">Edit </li>
                            </ol>
                        </div>
                        @section('page_title')
                            Edit  Feature
                        @endsection
                    </div>
                </div>
            </div>

            <!-- Content Form -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <h4 class="page-title">Edit </h4>
                                </div>
                            </div>

                            <form method="POST" action="{{ route('admin.plan_features.update', $plan_feature->id) }}">
                                @csrf
                                @method('PUT')

                                <div class="form-group">
                                    <label>Name:</label>
                                    <input type="text" name="name" class="form-control" value="{{ $plan_feature->name }}" required>
                                </div>

                                <button type="submit" class="btn btn-primary">Update</button>
                                <a href="{{ route('admin.plan_features.index', ['plan_id' => $plan_feature->plan_id]) }}" class="btn btn-secondary">Cancel</a>
                            </form>


                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- container -->
    </div> <!-- content -->
@endsection
