@extends('admin.layouts.main')

@section('content')
<div class="content">
    <div class="container-fluid">
        <!-- Page Title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.plan_features.index', [$plan->id]) }}">Features</a></li>
                            <li class="breadcrumb-item active">Create</li>
                        </ol>
                    </div>
                    @section('page_title')
                        Create Feature
                    @endsection
                </div>
            </div>
        </div>

        <!-- Form Card -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="page-title mb-3">
                            Create Feature for Plan: <strong>{{ $plan->name }}</strong>
                        </h4>
                        <hr>

                        <form method="POST" action="{{ route('admin.plan_features.store', [$plan->id]) }}">
                            @csrf

                            <div class="form-group">
                                <label>Name</label>
                                <input type="text" name="name" class="form-control" value="{{ old('name') }}" required>
                            </div>

                            <div class="form-group mt-4">
                                <button type="submit" class="btn btn-success">Save</button>
                                <a href="{{ route('admin.plan_features.index', [$plan->id]) }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
