@extends('admin.layouts.main')

@section('content')
<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="page-title">Feedbacks</h4>
                        <hr>
                        <div class="table-responsive">
                            <table id="example" class="table table-striped table-bordered dt-responsive nowrap">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>User</th>
                                        <th>Course</th>
                                        <th>Chapter</th>
                                        <th>Sub Chapter</th>
                                        <th>Content</th>
                                        <th>Feedback Type</th>
                                        <th>Message</th>
                                        <th>Created At</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($feedback as $i => $item)
                                    <tr>
                                        <td>{{ $i + 1 }}</td>
                                        <td>{{ $item->user->name ?? 'N/A' }}</td>
                                        <td>{{ $item->content->subChapter->chapter->course->name ?? 'N/A' }}</td>
                                        <td>{{ $item->content->subChapter->chapter->title ?? 'N/A' }}</td>
                                        <td>{{ $item->content->subChapter->title ?? 'N/A' }}</td>
                                        <td>{{ $item->content->title ?? 'N/A' }}</td>
                                        <td>{{ ucfirst($item->type) }}</td>
                                        <td>{{ $item->message }}</td>
                                        <td>{{ $item->created_at->format('d-m-Y H:i') }}</td>
                                        <td>
                                            <button data-value="{{ $item->id }}" 
                                                    class="btn btn-danger btn-xs cdelete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                            <form id="deleteform{{ $item->id }}" 
                                                action="{{ route('admin.feedbacks.destroy', $item->id) }}" 
                                                method="POST" style="display: none;">
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>    
</div>
@endsection

@section('jscode')
<script>
    $('.cdelete').on('click', function () {
        var id = $(this).data('value');
        Swal.fire({
            title: "Are you sure?",
            text: "This feedback will be moved to trash (soft deleted)!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#348cd4",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it!"
        }).then(function (result) {
            if (result.value == true) {
                $('#deleteform' + id).submit();
            }
        });
    });

</script>
<script language="javascript">
     $('#example').DataTable({
        responsive: true,
        columnDefs: [
            { responsivePriority: 1, targets: 0 }, // keep S.No visible
            { responsivePriority: 2, targets: -1 }, // keep Action visible
            { orderable: false, targets: -1 } // prevent sorting on Action column
        ]
    });
</script>
@endsection
