@extends('admin.layouts.main')

@section('content')
    <div class="content">

        <!-- Start Content-->
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item active">Dashboard</li>
                            </ol>
                        </div>
                        <h4 class="page-title">Welcome @if (Auth::check() && Auth::user())
                                {{ Auth::user()->name }}
                            @else
                                Admin
                            @endif !</h4>
                    </div>
                </div>
            </div>
            <!-- end page title -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h4>Users</h4>
                            <div class="row">
                                <div class="col-xl-3 col-md-6">
                                    <div class="card widget-box-two bg-primary">
                                        <a href="{{ route('admin.appUsers.index') }}">
                                            <div class="card-body">
                                                <div class="media">
                                                    <div class="media-body wigdet-two-content">
                                                        <p class="m-0 text-uppercase text-white" title="Statistics">Total Users
                                                        </p>
                                                        <h2 class="text-white">{{$totalActiveUsers}}</h2>
                                                        <!-- <p class="text-white m-0"><b>0%</b> From previous period</p> -->
                                                    </div>
                                                    <div
                                                        class="avatar-lg rounded-circle bg-soft-light ml-2 align-self-center">
                                                        <i
                                                            class="mdi mdi-account-group font-22 avatar-title text-white"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div><!-- end col -->
                                <div class="col-xl-3 col-md-6">
                                    <div class="card widget-box-two bg-success">
                                        <a href="{{ route('admin.subscriptions.index') }}">
                                            <div class="card-body">
                                                <div class="media">
                                                    <div class="media-body wigdet-two-content">
                                                        <p class="m-0 text-white text-uppercase" title="User Today">
                                                            Subscribers
                                                        </p>
                                                        <h2 class="text-white">{{$totalSubscribedUsers}}</h2>
                                                        <!-- <p class="text-white m-0"><b>0%</b> From previous period</p> -->
                                                    </div>
                                                    <div
                                                        class="avatar-lg rounded-circle bg-soft-light ml-2 align-self-center">
                                                        <i
                                                            class="mdi mdi-account-multiple  font-22 avatar-title text-white"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                    </div>
                                </div><!-- end col -->  
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end row -->
    </div> <!-- end container-fluid -->
    </div> <!-- end content -->
@endsection
