@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a
                                        href="{{ route('admin.courses.index') }}">Courses</a></li>
                                <li class="breadcrumb-item active">Edit Course</li>
                            </ol>
                        </div>
                    @section('page_title')
                        Edit Course
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Edit Course</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="{{ route('admin.courses.update', $course) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="form-group">
                                <label for="image">Current Image</label>
                                <div>
                                    <img src="{{ asset('uploads/courses/' . $course->image) }}"
                                        alt="{{ $course->title }}" height="100">
                                </div>
                                <br>
                                <label for="image">Change Course Image</label>
                                <input type="file" name="image" id="image" class="form-control">
                                <small class="form-text text-muted">Leave blank to keep the current image. Recommended
                                    size: 1200x400px</small>
                            </div>

                            <div class="form-group">
                                <label for="title">Name</label>
                                <input type="text" name="name" id="name" class="form-control"
                                    value="{{ old('name', $course->name) }}">
                            </div>
                            
                             <div class="form-group">
                                <label for="fullname">Priority * :</label>
                                <input type="number" class="form-control @error('priority') is-invalid @enderror"
                                    name="priority" id="priority"
                                    value="{{ old('priority', $course->priority ?? null) }}" autocomplete="off">
                                @error('priority')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

  
                            <div class="form-group">
                                <label for="is_active">Is Active *</label>
                                <select name="is_active" id="is_active" class="form-control" required>
                                    <option value="1" {{ old('is_active', $course->is_active) == 1 ? 'selected' : '' }}>
                                        Active</option>
                                    <option value="0" {{ old('is_active', $course->is_active) == 0 ? 'selected' : '' }}>
                                        Inactive</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Update Course</button>
                            <a href="{{ route('admin.courses.index') }}" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
