@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <div class="container-fluid">
            <!-- Page Title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('admin.contents.index', [$type, $content->sub_chapter_id]) }}">
                                    {{ ucwords(str_replace('_', ' ', $type)) }} List</a></li>
                                <li class="breadcrumb-item active">Edit {{ ucwords(str_replace('_', ' ', $type)) }}</li>
                            </ol>
                        </div>
                        @section('page_title')
                            Edit {{ ucwords(str_replace('_', ' ', $type)) }} Content
                        @endsection
                    </div>
                </div>
            </div>

            <!-- Content Form -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <h4 class="page-title">Edit {{ ucwords(str_replace('_', ' ', $type)) }}</h4>
                                </div>
                            </div>

                            <form method="POST" action="{{ route('admin.contents.update', $content->id) }}" enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                
                                @if($type !== 'reasoning_question')
                                    <div class="form-group">
                                        <label>Title:</label>
                                        <input type="text" name="title" class="form-control" value="{{ $content->title }}" required>
                                    </div>
                                @endif

                                @if(in_array($type, ['mcq', 'clinical_scenario', 'neet_pg_mcq']))
                                    @php
                                        $json = json_decode($content->text_content, true);
                                    @endphp

                                    <div class="form-group">
                                        <label>Question{{ $type == 'neet_pg_mcq' ? ' (Supports HTML)' : '' }}:</label>
                                        <textarea name="question" class="form-control" rows="4" required id="editor">{{ $json['question'] ?? '' }}</textarea>
                                    </div>

                                    @if($type == 'neet_pg_mcq')
                                        <div class="form-group">
                                            <label>Current Image:</label><br>
                                            <img src="{{ asset('uploads/'.$type.'/' . ($json['image'] ?? ''))  }}" alt="MCQ Image" width="200">
                                            <!--<img src="{{ asset('uploads/notes/' . $content->image_url) }}" alt="MCQ Image" width="200">-->
                                        </div>

                                        <div class="form-group">
                                            <label>Change Image:</label>
                                            <input type="file" name="image" class="form-control">
                                            <small class="text-muted">Leave empty to keep existing image.</small>
                                        </div>
                                    @endif

                                    @foreach ($json['options'] ?? [] as $index => $option)
                                        <div class="form-group">
                                            <label>Option {{ $index + 1 }}:</label>
                                            <input type="text" name="option_{{ $index + 1 }}" class="form-control" value="{{ $option }}" required>
                                        </div>
                                    @endforeach

                                    <div class="form-group">
                                        <label>Correct Option (1-4):</label>
                                        <input type="number" name="correct_option" class="form-control" min="1" max="4" value="{{ $json['correct'] ?? 1 }}" required>
                                    </div>

                                    <div class="form-group">
                                        <label>Explanation:</label>
                                        <textarea name="explanation" class="form-control">{{ $json['explanation'] ?? '' }}</textarea>
                                    </div>
                                @endif

                                @if($type === 'reasoning_question')
                                    @php
                                        $json = json_decode($content->text_content, true);
                                    @endphp

                                    <div class="form-group" id="question_div">
                                        <label>Question</label>
                                        <textarea name="question" class="form-control" rows="4">{{ $json['question'] ?? '' }}</textarea>
                                    </div>

                                    <div class="form-group" id="answer_div">
                                        <label>Answer</label>
                                        <textarea name="answer" class="form-control" rows="4">{{ $json['answer'] ?? '' }}</textarea>
                                    </div>
                                    
                                    <div class="form-group" id="explanation_div">
                                        <label>Explanation</label>
                                        <textarea name="explanation" class="form-control" rows="4">{{ $json['explanation'] ?? '' }}</textarea>
                                    </div>
                                @endif


                                <button type="submit" class="btn btn-primary">Update</button>
                                <a href="{{ route('admin.contents.index', [$type, $content->sub_chapter_id]) }}" class="btn btn-secondary">Cancel</a>
                            </form>

                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- container -->
    </div> <!-- content -->
@endsection
