@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a
                                        href="{{ route('admin.colleges.index') }}">Colleges</a></li>
                                <li class="breadcrumb-item active">Edit College</li>
                            </ol>
                        </div>
                    @section('page_title')
                        Edit College
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Edit College</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="{{ route('admin.colleges.update', $college) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="form-group">
                                <label for="title">Name</label>
                                <input type="text" name="name" id="name" class="form-control"
                                    value="{{ old('name', $college->name) }}">
                            </div>

                            <button type="submit" class="btn btn-primary">Update College</button>
                            <a href="{{ route('admin.colleges.index') }}" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
