@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="{{ url('/admin/colleges') }}">Colleges</a></li>
                                <li class="breadcrumb-item active"> Content</li>
                            </ol>
                        </div>
                        @section('page_title')
                             Content
                        @endsection
                    </div>
                </div>
            </div>
            <!-- end page title -->

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            @if (Session::has('message'))
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                    <strong>Success!</strong> {{ Session::get('message') }}
                                </div>
                            @endif

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <h4 class="page-title"> Content</h4>
                                </div>
                                <div class="col-md-6 text-right">
                                    <a href="{{ route('admin.college_contents.create', [$college_id]) }}"
                                       class="btn btn-success float-right">
                                        <i class="fas fa-plus"></i> Add 
                                    </a>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table id="example" class="table table-striped table-bordered dt-responsive nowrap"
                                       style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Title</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($CollegeContent as $index => $content)
                                            <tr>
                                                <td>{{ $index + 1 }}</td>
                                                <td>{!! $content->title ?? '' !!}</td>
                                                <td>
                                                    <a href="{{ route('admin.college_contents.edit', $content->id) }}"
                                                       class="btn btn-primary btn-xs"><i class="fas fa-pen"></i></a>

                                                    <button data-value="{{ $content->id }}"
                                                            class="btn btn-danger btn-xs cdelete"><i class="fas fa-trash"></i></button>

                                                    <form id="deleteform{{ $content->id }}" method="POST"
                                                          action="{{ route('admin.college_contents.destroy', $content->id) }}"
                                                          style="display: none;">
                                                        @csrf
                                                        @method('DELETE')
                                                    </form>

                                                    
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                        </div> <!-- end card-body -->
                    </div> <!-- end card -->
                </div> <!-- end col -->
            </div> <!-- end row -->

        </div> <!-- container -->
    </div> <!-- content -->
@endsection

@section('jscode')
<script>
    $('.cdelete').on('click', function () {
        var id = $(this).data('value');
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#348cd4",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it!"
        }).then(function (result) {
            //if (result.isConfirmed) {
            if (result.value == true) {
                $('#deleteform' + id).submit();
                //document.getElementById('deleteform' + id).submit();
            }
        });
    });

    $('#example').DataTable({
        responsive: true
    });
</script>
@endsection
