@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <div class="container-fluid">
            <!-- Page Title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a href="{{ route('admin.college_contents.index', ['college_id' => $content->college_id]) }}">
                                     List</a></li>
                                <li class="breadcrumb-item active">Edit </li>
                            </ol>
                        </div>
                        @section('page_title')
                            Edit  Content
                        @endsection
                    </div>
                </div>
            </div>

            <!-- Content Form -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <h4 class="page-title">Edit </h4>
                                </div>
                            </div>

                            <form method="POST" action="{{ route('admin.college_contents.update', $content->id) }}" enctype="multipart/form-data">
                                @csrf
                                @method('PUT')

                                <div class="form-group">
                                    <label>Title:</label>
                                    <input type="text" name="title" class="form-control" value="{{ $content->title }}" required>
                                </div>

                               @if($content->pdf_url)
                                    <div class="form-group">
                                        <label>Current PDF</label>
                                        <div>
                                            <a href="{{ asset('uploads/college/' . $content->pdf_url) }}" target="_blank">
                                                View current PDF
                                            </a>
                                        </div>
                                    </div>
                                @endif

                                <div class="form-group">
                                    <label for="file">Upload New PDF</label>
                                    <input type="file" name="file" id="file" class="form-control">
                                    <small class="form-text text-muted">Leave blank to keep the current PDF. Max size: 5MB</small>
                                </div>

                                <button type="submit" class="btn btn-primary">Update</button>
                                <a href="{{ route('admin.college_contents.index', [$content->college_id]) }}" class="btn btn-secondary">Cancel</a>
                            </form>

                        </div>
                    </div>
                </div>
            </div>

        </div> <!-- container -->
    </div> <!-- content -->
@endsection
