@extends('admin.layouts.main')

@section('content')
<div class="content">
    <div class="container-fluid">
        <!-- Page Title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.college_contents.index', [$college->id]) }}"> Content</a></li>
                            <li class="breadcrumb-item active">Create</li>
                        </ol>
                    </div>
                    @section('page_title')
                        Create Content
                    @endsection
                </div>
            </div>
        </div>

        <!-- Form Card -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <h4 class="page-title mb-3">Create Content for College: <strong>{{ $college->title }}</strong></h4>
                        <hr>

                        <form method="POST" action="{{ route('admin.college_contents.store', [$college->id]) }}" enctype="multipart/form-data">
                            @csrf

                            <div class="form-group">
                                <label>Title</label>
                                <input type="text" name="title" class="form-control" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="file">Upload New PDF</label>
                                <input type="file" name="file" id="file" class="form-control">
                                <small class="form-text text-muted">Leave blank to keep the current PDF. Max size: 5MB</small>
                            </div>
                                

                            <div class="form-group mt-4">
                                <button type="submit" class="btn btn-success">Save</button>
                                <a href="{{ route('admin.college_contents.index', [$college->id]) }}" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
