@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a
                                        href="{{ route('admin.chapters.index') }}">Chapter</a></li>
                                <li class="breadcrumb-item active">Edit Chapter</li>
                            </ol>
                        </div>
                    @section('page_title')
                        Edit Chapter
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Edit Chapter</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="{{ route('admin.chapters.update', $chapter) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" id="title" class="form-control"
                                    value="{{ old('title', $chapter->title) }}" required>
                            </div>

                             <div class="form-group">
                                <label for="course_id">Course</label>
                                <select name="course_id" id="course_id" class="form-control" required>
                                    <option value="">-- Select Course --</option>
                                    @foreach ($courses as $course)
                                        <option value="{{ $course->id }}" {{ (old('course_id', $chapter->course_id) == $course->id) ? 'selected' : '' }}>
                                            {{ $course->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <!--<div class="form-group">-->
                            <!--    <label for="chapter_type">Chapter Type</label>-->
                            <!--    <select name="chapter_type" id="chapter_type" class="form-control" required>-->
                            <!--        <option value="">-- Select Chapter Type --</option>-->
                            <!--        @foreach (chapterTypeOptions() as $key => $label)-->
                            <!--            <option value="{{ $key }}"-->
                            <!--                {{ old('chapter_type', $chapter->chapter_type ?? '') == $key ? 'selected' : '' }}>-->
                            <!--                {{ $label }}-->
                            <!--            </option>-->
                            <!--        @endforeach-->
                            <!--    </select>-->
                            <!--</div>-->
                            
                            <div class="form-group" id="chapter_type_group">
                                <label for="chapter_type">Chapter Type</label>
                                <select name="chapter_type" id="chapter_type" class="form-control">
                                    <option value="">-- Select Chapter Type --</option>
                                    @foreach (chapterTypeOptions() as $key => $label)
                                        <option value="{{ $key }}"
                                            {{ old('chapter_type', $chapter->chapter_type ?? '') == $key ? 'selected' : '' }}>
                                            {{ $label }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <input type="hidden" name="forced_chapter_type" id="forced_chapter_type"
                                   value="{{ old('chapter_type', $chapter->chapter_type ?? '') }}">


                            <div class="form-group">
                                <label for="order_index" id="order_index_label">Chapter No.</label>
                                <input type="text" name="order_index" id="order_index" class="form-control"
                                    value="{{ old('order_index', $chapter->order_index) }}">
                            </div>

                            <button type="submit" class="btn btn-primary">Update Chapter</button>
                            <a href="{{ route('admin.chapters.index') }}" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        let courseSelect = document.getElementById('course_id');
        let chapterTypeGroup = document.getElementById('chapter_type_group');
        let forcedChapterType = document.getElementById('forced_chapter_type');

        function checkCourse() {
            let selectedText = courseSelect.options[courseSelect.selectedIndex]?.text.toLowerCase() || "";

            if (selectedText.includes("neet pg mcq")) {
                chapterTypeGroup.style.display = "none";
                forcedChapterType.value = "neet_pg_mcq";
            } 
            else if (selectedText.includes("past question paper")) {
                chapterTypeGroup.style.display = "none";
                forcedChapterType.value = "past_paper";
            } 
            else {
                chapterTypeGroup.style.display = "block";
                forcedChapterType.value = ""; // no forced type
            }
        }

        checkCourse(); // on load
        courseSelect.addEventListener('change', checkCourse);
    });
</script>
@endsection

