@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item"><a
                                        href="{{ route('admin.banners.index') }}">Banners</a></li>
                                <li class="breadcrumb-item active">Edit Banner</li>
                            </ol>
                        </div>
                    @section('page_title')
                        Edit Banner
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Edit Banner</h4>
                            </div>
                        </div>
                        <hr>

                        <form action="{{ route('admin.banners.update', $banner) }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            @method('PUT')

                            <div class="form-group">
                                <label for="image">Current Image</label>
                                <div>
                                    <img src="{{ asset('uploads/banners/' . $banner->image) }}"
                                        alt="{{ $banner->title }}" height="100">
                                </div>
                                <br>
                                <label for="image">Change Banner Image</label>
                                <input type="file" name="image" id="image" class="form-control">
                                <small class="form-text text-muted">Leave blank to keep the current image. Recommended
                                    size: 1200x400px</small>
                            </div>

                            <div class="form-group">
                                <label for="title">Title</label>
                                <input type="text" name="title" id="title" class="form-control"
                                    value="{{ old('title', $banner->title) }}">
                            </div>

                            <div class="form-group">
                                <label for="priority">Priority *</label>
                                <input type="number" name="priority" id="priority" class="form-control"
                                    value="{{ old('priority', $banner->priority) }}" required>
                            </div>

                            <div class="form-group">
                                <label for="status">Status *</label>
                                <select name="status" id="status" class="form-control" required>
                                    <option value="1" {{ old('status', $banner->status) == 1 ? 'selected' : '' }}>
                                        Active</option>
                                    <option value="0" {{ old('status', $banner->status) == 0 ? 'selected' : '' }}>
                                        Inactive</option>
                                </select>
                            </div>

                            <button type="submit" class="btn btn-primary">Update Banner</button>
                            <a href="{{ route('admin.banners.index') }}" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
