@extends('admin.layouts.main')

@section('content')
    <div class="content">
        <div class="container-fluid">
            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item active">Users</li>
                            </ol>
                        </div>
                        @section('page_title')
                            Users
                        @endsection
                    </div>
                </div>
            </div>
        </div>

        <!-- Users Table -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        @if (Session::has('message'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <strong>Success!</strong> {{ Session::get('message') }}
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        @endif

                        <h4 class="page-title">Users</h4>
                        <hr>

                        <div class="table-responsive">
                            <table id="example" class="table table-striped table-bordered dt-responsive nowrap"
                                style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>Sr. No.</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Mobile</th>
                                        <th>Photo</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $i=0;@endphp
                                    @foreach ($appUser as $index => $user)
                                        <tr>
                                            <td>{{ ++$i }}</td>
                                            <td>{{ $user->name }}</td>
                                            <td>{{ $user->email }}</td>
                                            <td>{{ $user->mobile_no }}</td>
                                            <td>
                                                @if ($user->profile_photo_url)
                                                    <img src="{{ asset('uploads/' . $user->profile_photo_url) }}"
                                                         alt="Profile Photo" width="40" height="40"
                                                         class="rounded-circle">
                                                @else
                                                    <img src="{{ asset('images/default.png') }}"
                                                         alt="Default" width="40" height="40"
                                                         class="rounded-circle">
                                                @endif
                                            </td>
                                            <td>
                                                <form action="{{ route('admin.appUsers.toggleStatus', $user->id) }}" method="POST" style="display:inline;">
                                                    @csrf
                                                    @method('PATCH')
                                                    @if ($user->is_active)
                                                        <button type="submit" class="btn btn-success btn-sm">
                                                            Active
                                                        </button>
                                                    @else
                                                        <button type="submit" class="btn btn-danger btn-sm">
                                                            Inactive
                                                        </button>
                                                    @endif
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('jscode')
<script>
    $('#example').DataTable({
        responsive: true
    });
</script>
@endsection
