@extends('admin.layouts.main')

@section('content')

    <div class="content">

        <!-- Start Content-->
        <div class="container-fluid">

            <!-- start page title -->
            <div class="row">
                <div class="col-12">
                    <div class="page-title-box">
                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                                <li class="breadcrumb-item active">App Splash Screens</li>
                            </ol>
                        </div>
                    @section('page_title')
                        App Splash Screens
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-12">
                <div class="card">

                    <div class="card-body">
                        @if (Session::has('message'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <strong>Success!</strong> {{ Session::get('message') }}
                            </div>
                        @endif
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">App Splash Screens</h4>
                            </div>
                            <div class="col-md-6">
                                <a href="{{ route('admin.app_splash_screens.create') }}">
                                    <button class="btn btn-success float-right ml-2"><i class="fas fa-plus"></i>
                                        Create App Splash Screens
                                    </button>
                                </a>
                            </div>
                        </div>
                        <hr>
                        <div class="table-responsive">
                            <table id="example" class="table table-striped table-bordered dt-responsive nowrap"
                                style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                <thead>
                                    <tr>
                                        <th>S.No</th>
                                        <th>Image</th>
                                        <th>Priority</th>
                                        <th>Title</th>
                                        <th>Description</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($screens as $key => $screen)
                                        <tr>
                                            <td>{{ $key + 1 }}</td>
                                            <td>
                                                @if ($screen->image)
                                                    <a href="{{ asset('uploads') }}/{{ $screen->image }}"
                                                        target="_blank">
                                                        <img class="avatar-lg"
                                                            src="{{ asset('uploads') }}/{{ $screen->image }}">
                                                    </a>
                                                @else
                                                    <span class="badge badge-warning">No App Splash Screen Image</span>
                                                @endif
                                            </td>
                                            <td>{{ $screen->priority }}</td>
                                            <td>{{ $screen->title }}</td>
                                            <td>{{ $screen->description }}</td>
                                            <td>
                                                <a href="{{ route('admin.app_splash_screens.edit', [$screen->id]) }}"
                                                    class="btn btn-primary waves-effect waves-light btn-xs"><i
                                                        class="fas fa-pen"></i></a>
                                                <button data-value="{{ $screen->id }}"
                                                    class="btn btn-danger waves-effect waves-light btn-xs cdelete">
                                                    <i class="fas fa-trash"></i></button>
                                                <form id="deleteform{{ $screen->id }}" method="post"
                                                    action="{{ route('admin.app_splash_screens.destroy', [$screen->id]) }}">
                                                    @csrf
                                                    {{ method_field('DELETE') }}
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div> <!-- end card -->
            </div> <!-- end col -->
        </div>
    </div> <!-- end container-fluid -->
</div> <!-- end content -->
@endsection
@section('jscode')
<script>
    $('.cdelete').on('click', function() {
        var id = $(this).data('value');
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            type: "warning",
            showCancelButton: !0,
            confirmButtonColor: "#348cd4",
            cancelButtonColor: "#6c757d",
            confirmButtonText: "Yes, delete it!"
        }).then(function(t) {
            if (t.value == true) {
                $("#deleteform" + id).submit();
            }
        })
    });
</script>
<script language="javascript">
     $('#example').DataTable({
        responsive: true,
        columnDefs: [
            { responsivePriority: 1, targets: 0 }, // keep S.No visible
            { responsivePriority: 2, targets: -1 }, // keep Action visible
            { orderable: false, targets: -1 } // prevent sorting on Action column
        ]
    });
</script>
@endsection
