@extends('admin.layouts.main')

@section('content')

<div class="content">

    <!-- Start Content-->
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.app_splash_screens.index') }}">App Splash Screens</a></li>
                            <li class="breadcrumb-item active">Create App Splash Screens</li>
                        </ol>
                    </div>
                    @section('page_title')
                    Create App Splash Screens
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Create App Splash Screens</h4>
                            </div>
                        </div>
                        <hr>
                        <form id="form"  method="post" action="{{ route('admin.app_splash_screens.store') }}" enctype="multipart/form-data">@csrf

                            <div class="form-group">
                                <label for="fullname">Image *  :</label>
                                <input type="file"  class="dropify"  name="image" id="image" accept="image/*">
                                <span>Image <code>Width:468px & Height:430px</code></span>
                                @error('image')
                                <span class="invalid-feedback" role="alert" style="display: block !important;">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="fullname">Priority * :</label>
                                <input type="number" class="form-control @error('priority') is-invalid @enderror" name="priority" id="priority"  value="{{ old('priority') }}"  autocomplete="off">
                                @error('priority')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Title * :</label>
                                <input type="text" class="form-control @error('title') is-invalid @enderror" name="title" id="title"  value="{{ old('title') }}"  autocomplete="off">
                                @error('title')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Description * :</label>
                                <textarea id="ee" class="form-control @error('description') is-invalid @enderror" name="description" id="description"></textarea>
                                @error('description')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="form-group mb-0">
                                <input type="submit" name="submit" class="btn btn-success" value="Create">
                            </div>

                        </form>
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <!-- end row -->

    </div> <!-- end container-fluid -->

</div> <!-- end content -->




@endsection
