@extends('admin.layouts.main')

@section('content')

<div class="content">

    <!-- Start Content-->
    <div class="container-fluid">

        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ url('/admin') }}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.app_setting.index') }}">App Settings</a></li>
                            <li class="breadcrumb-item active">Edit App Settings </li>
                        </ol>
                    </div>
                    @section('page_title')
                    App Settings
                    @endsection
                </div>
            </div>
        </div>
        <!-- end page title -->
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4 class="page-title">Edit App Settings</h4>
                            </div>
                        </div>
                        <hr>
                        <form id="form"  method="post" action="{{ route('admin.app_setting.update', [$settings->id]) }}" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="url" value="{{URL::previous()}}">

                            <div class="form-group">
                                <label for="fullname">Android Latest Version No  :</label>
                                <input type="text" class="form-control" name="android_latest_version_no" id="android_latest_version_no"  value="{{ old('android_latest_version_no',$settings->android_latest_version_no ?? null) }}"  autocomplete="off">
                                @error('android_latest_version_no')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Android Latest Version Note:</label>
                                <input type="text" class="form-control" name="android_latest_version_note" id="android_latest_version_note"  value="{{ old('android_latest_version_note',$settings->android_latest_version_note ?? null) }}"  autocomplete="off">
                                @error('android_latest_version_note')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Android Download Link:</label>
                                <input type="text" class="form-control" name="android_download_link" id="android_download_link"  value="{{ old('android_download_link',$settings->android_download_link ?? null) }}"  autocomplete="off">
                                @error('android_download_link')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="fullname">Android Force Update Required* :</label>
                                <select class="form-control @error('android_force_update_required') is-invalid @enderror" name="android_force_update_required" id="android_force_update_required" >
                                    <option value="yes"  {{ ($settings->android_force_update_required=='yes') ? 'selected':'' }}>Yes</option>
                                    <option value="no"  {{ ($settings->android_force_update_required=='no') ? 'selected':'' }}>No</option>

                                </select>
                                @error('android_force_update_required')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Ios Latest Version No  :</label>
                                <input type="text" class="form-control" name="ios_latest_version_no" id="ios_latest_version_no"  value="{{ old('ios_latest_version_no',$settings->ios_latest_version_no ?? null) }}"  autocomplete="off">
                                @error('ios_latest_version_no')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Ios Latest Version Note:</label>
                                <input type="text" class="form-control" name="ios_latest_version_note" id="ios_latest_version_note"  value="{{ old('ios_latest_version_note',$settings->ios_latest_version_note ?? null) }}"  autocomplete="off">
                                @error('ios_latest_version_note')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="fullname">Ios Download Link:</label>
                                <input type="text" class="form-control" name="ios_app_download_link" id="ios_app_download_link"  value="{{ old('ios_app_download_link',$settings->ios_app_download_link ?? null) }}"  autocomplete="off">
                                @error('ios_app_download_link')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>

                            <div class="form-group">
                                <label for="fullname">Ios Force Update Required* :</label>
                                <select class="form-control @error('ios_force_update_required') is-invalid @enderror" name="ios_force_update_required" id="ios_force_update_required" >
                                    <option value="yes"  {{ ($settings->ios_force_update_required=='yes') ? 'selected':'' }}>Yes</option>
                                    <option value="no"  {{ ($settings->ios_force_update_required=='no') ? 'selected':'' }}>No</option>

                                </select>
                                @error('ios_force_update_required')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>


                            <div class="form-group mb-0">
                                <input type="submit" name="submit" class="btn btn-success" value="Submit">
                            </div>

                        </form>
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <!-- end row -->

    </div> <!-- end container-fluid -->

</div> <!-- end content -->




@endsection
