<?php

namespace App\Providers;

// use Illuminate\Support\Facades\Gate;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use App\Models\User;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        //
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        Gate::define('isInfluencer', function (User $user) {
            return $user->isInfluencer(); // Uses the method from User model
        });

        Gate::define('isBusiness', function (User $user) {
            return $user->isBusiness(); // Uses the method from User model
        });

        Gate::define('isAdmin', function (User $user) {
            return $user->isAdmin();
        });
    }
}
