<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'course_id',
        'plan_id',
        'start_date',
        'end_date',
        'status',
        'razorpay_order_id',
        'razorpay_payment_id',
    ];


    protected $hidden = [
        'updated_at',
        'created_at',
    ];

    protected $casts = [
        'start_date' => 'datetime',
        'end_date' => 'datetime',
    ];

    // Relationships

    public function user()
    {
        return $this->belongsTo(AppUser::class);
    }

    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }
}
