<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SubChapterFavorite extends Model
{
    protected $table = 'sub_chapters_favorite';

    protected $fillable = ['user_id','sub_chapter_id','is_favorite'];

    protected $hidden = ['created_at', 'updated_at'];

    public function subChapter()
    {
        return $this->belongsTo(SubChapter::class);
    }
    
    public function getIsFreeAttribute($value)
    {
        return $value == 1 ? true : false;
    }

}
