<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubChapter extends Model
{
    use SoftDeletes;

    protected $fillable = ['chapter_id','title','order_index','is_free','is_favorite'];

    protected $hidden = ['created_at', 'updated_at','order_index'];

    public function chapter()
    {
        return $this->belongsTo(Chapter::class);
    }

    public function contents()
    {
        return $this->hasMany(Content::class);
    }
    
    protected $casts = [
        'chapter_id' => 'integer',  // 👈 Force integer
        'is_favorite'=> 'boolean',  // optional: convert favorite too
    ];
    
    public function getIsFreeAttribute($value)
    {
        return $value == 1 ? true : false;
    }

}
